/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.log;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.LookupInSpec;
import com.couchbase.transactions.error.internal.ErrorClasses;
import com.couchbase.transactions.log.LogEntry;
import java.util.Arrays;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Stability.Internal
public class PersistedLogReader {
    public static Flux<LogEntry> read(Collection collection) {
        return collection.reactive().lookupIn("txn-log", Arrays.asList(LookupInSpec.get((String)"l.logs").xattr())).onErrorResume(err -> {
            ErrorClasses ec = ErrorClasses.classify(err);
            if (ec == ErrorClasses.FAIL_DOC_NOT_FOUND) {
                return Mono.empty();
            }
            return Mono.error((Throwable)err);
        }).flatMapMany(result -> {
            JsonArray logs = result.contentAsArray(0);
            return Flux.fromIterable((Iterable)logs).map(log -> LogEntry.create((JsonObject)log));
        });
    }
}

