/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.log;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.MutateInMacro;
import com.couchbase.client.java.kv.MutateInOptions;
import com.couchbase.client.java.kv.MutateInSpec;
import com.couchbase.client.java.kv.StoreSemantics;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import reactor.core.publisher.Mono;

@Stability.Internal
public class PersistedLogWriter {
    public static final String PERSISTED_LOG_DOC_ID = "txn-log";
    public static final int MAX_LOG_ENTRIES_DEFAULT = 100000;
    private final Collection collection;
    private final int maxEntries;
    private boolean compactionRequired;

    public PersistedLogWriter(Collection collection, int maxEntries) {
        this.collection = collection;
        this.maxEntries = maxEntries;
    }

    public Mono<Void> write(String clientUuid, String v) {
        JsonObject obj = JsonObject.create().put("v", v).put("u", clientUuid).put("t", LocalDateTime.now().toString());
        ArrayList<Object> ops = new ArrayList<Object>();
        MutateInOptions opts = MutateInOptions.mutateInOptions();
        if (this.compactionRequired) {
            int NUMBER_OF_SUBDOC_OPS_REMAINING = 13;
            ops.add(MutateInSpec.decrement((String)"l.count", (long)(NUMBER_OF_SUBDOC_OPS_REMAINING - 1)).xattr().createPath());
            for (int i = 0; i < 13; ++i) {
                ops.add(MutateInSpec.remove((String)"l.logs[0]").xattr());
            }
            this.compactionRequired = false;
        } else {
            ops.add(MutateInSpec.increment((String)"l.count", (long)1L).xattr().createPath());
            opts.storeSemantics(StoreSemantics.UPSERT);
        }
        ops.add(MutateInSpec.arrayAppend((String)"l.logs", Arrays.asList(obj)).xattr().createPath());
        ops.add(MutateInSpec.upsert((String)"l.logs[-1].c", (Object)MutateInMacro.CAS));
        return this.collection.reactive().mutateIn(PERSISTED_LOG_DOC_ID, ops, opts).doOnNext(result -> {
            try {
                Integer count = (Integer)result.contentAs(0, Integer.class);
                if (count >= this.maxEntries) {
                    this.compactionRequired = true;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }).then();
    }

    public boolean compactionRequired() {
        return this.compactionRequired;
    }
}

