/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.log;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.transactions.log.LogDefer;
import com.couchbase.transactions.log.TransactionLogEvent;
import com.couchbase.transactions.support.QuickFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Stability.Internal
public class TransactionLogger {
    private final EventBus eventBus;
    private final List<LogDefer> logs = Collections.synchronizedList(new ArrayList());
    private final boolean logDirectly;
    private final Event.Severity logDirectlyAboveLevel;
    private final String transactionId;
    private final QuickFormat format = new QuickFormat();

    public TransactionLogger(EventBus eventBus, String primaryId, boolean logDirectly, Event.Severity logDirectlyAboveLevel) {
        Objects.requireNonNull(eventBus);
        Objects.requireNonNull(primaryId);
        Objects.requireNonNull(logDirectlyAboveLevel);
        this.eventBus = eventBus;
        this.transactionId = primaryId;
        this.logDirectly = logDirectly;
        this.logDirectlyAboveLevel = logDirectlyAboveLevel;
    }

    public void debug(Throwable err) {
        this.log(err, Event.Severity.DEBUG);
    }

    public void debug(String secondaryId, Throwable err) {
        this.log(secondaryId, err, Event.Severity.DEBUG);
    }

    public void info(String secondaryId, Throwable err) {
        this.log(secondaryId, err, Event.Severity.INFO);
    }

    public void log(String secondaryId, Throwable err, Event.Severity level) {
        String st = Arrays.stream(err.getStackTrace()).map(v -> v.toString()).collect(Collectors.joining("\n"));
        this.log(secondaryId, st, level);
    }

    public void log(Throwable err, Event.Severity level) {
        String st = Arrays.stream(err.getStackTrace()).map(v -> v.toString()).collect(Collectors.joining("\n"));
        this.log(st, level);
    }

    public void logDefer(String secondaryId, String fmt, Event.Severity level, Object ... values) {
        LogDefer defer = new LogDefer(System.currentTimeMillis(), Thread.currentThread().getId(), Thread.currentThread().getName(), this.transactionId, secondaryId, fmt, values, level, this.format);
        this.logs.add(defer);
        if (this.logDirectly && level.ordinal() >= this.logDirectlyAboveLevel.ordinal()) {
            this.logDirectly(level, defer.toString());
        }
    }

    public void logDefer(String secondaryId, String fmt, Event.Severity level) {
        LogDefer defer = new LogDefer(System.currentTimeMillis(), Thread.currentThread().getId(), Thread.currentThread().getName(), this.transactionId, secondaryId, fmt, null, level, this.format);
        this.logs.add(defer);
        if (this.logDirectly && level.ordinal() >= this.logDirectlyAboveLevel.ordinal()) {
            this.logDirectly(level, defer.toString());
        }
    }

    private void logDirectly(Event.Severity level, String s) {
        this.eventBus.publish((Event)new TransactionLogEvent(level, TransactionLogEvent.DEFAULT_CATEGORY, s));
    }

    public void log(String secondaryId, String value, Event.Severity level) {
        this.logDefer(secondaryId, value, level);
    }

    public void log(String value, Event.Severity level) {
        this.logDefer(null, value, level);
    }

    public void error(String secondaryId, String value) {
        this.log(secondaryId, value, Event.Severity.ERROR);
    }

    public void warn(String secondaryId, String value) {
        this.log(secondaryId, value, Event.Severity.WARN);
    }

    public void warn(String secondaryId, String fmt, Object ... values) {
        this.logDefer(secondaryId, fmt, Event.Severity.WARN, values);
    }

    public void info(String secondaryId, String value) {
        this.log(secondaryId, value, Event.Severity.INFO);
    }

    public void debug(String secondaryId, String value) {
        this.log(secondaryId, value, Event.Severity.DEBUG);
    }

    public void debug(String secondaryId, String fmt, Object ... values) {
        this.logDefer(secondaryId, fmt, Event.Severity.DEBUG, values);
    }

    public void trace(String secondaryId, String value) {
        this.log(secondaryId, value, Event.Severity.VERBOSE);
    }

    public void error(String value) {
        this.log(value, Event.Severity.ERROR);
    }

    public void warn(String value) {
        this.log(value, Event.Severity.WARN);
    }

    public void info(String value) {
        this.log(value, Event.Severity.INFO);
    }

    public void debug(String value) {
        this.log(value, Event.Severity.DEBUG);
    }

    public void trace(String value) {
        this.log(value, Event.Severity.VERBOSE);
    }

    public void trace(String secondaryId, String fmt, Object ... values) {
        this.logDefer(secondaryId, fmt, Event.Severity.VERBOSE, values);
    }

    public void info(String secondaryId, String fmt, Object ... values) {
        this.logDefer(secondaryId, fmt, Event.Severity.INFO, values);
    }

    public void info(String fmt, Object ... values) {
        this.logDefer(null, fmt, Event.Severity.INFO, values);
    }

    public List<LogDefer> logs() {
        return this.logs;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }
}

