/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.support;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.kv.InsertOptions;
import com.couchbase.client.java.kv.MutateInOptions;
import com.couchbase.client.java.kv.RemoveOptions;
import com.couchbase.transactions.TransactionDurabilityLevel;
import com.couchbase.transactions.config.PerTransactionConfig;
import com.couchbase.transactions.config.TransactionConfig;
import com.couchbase.transactions.support.SpanWrapper;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class OptionsWrapperUtil {
    private OptionsWrapperUtil() {
    }

    public static Duration kvTimeoutNonMutating(TransactionConfig config, Core core) {
        return config.keyValueTimeout().orElse(core.context().environment().timeoutConfig().kvTimeout());
    }

    public static Duration kvTimeoutMutating(TransactionConfig config, Core core) {
        return config.keyValueTimeout().orElse(core.context().environment().timeoutConfig().kvDurableTimeout());
    }

    public static InsertOptions wrap(InsertOptions opts, SpanWrapper pspan, TransactionConfig config, PerTransactionConfig perTxn, Core core) {
        opts.timeout(OptionsWrapperUtil.kvTimeoutMutating(config, core));
        if (perTxn.durabilityLevel().isPresent()) {
            DurabilityLevel dl = OptionsWrapperUtil.convert(perTxn.durabilityLevel().get());
            opts.durability(dl);
        } else if (config.transactionDurabilityLevel() != TransactionDurabilityLevel.NONE) {
            opts.durability(config.durabilityLevel());
        }
        return opts;
    }

    public static InsertOptions wrap(InsertOptions opts, SpanWrapper pspan, TransactionConfig config, Core core) {
        return OptionsWrapperUtil.wrap(opts, config, Optional.empty(), core);
    }

    public static InsertOptions wrap(InsertOptions opts, TransactionConfig config, Optional<DurabilityLevel> override, Core core) {
        opts.timeout(OptionsWrapperUtil.kvTimeoutMutating(config, core));
        if (override.isPresent()) {
            opts.durability(override.get());
        } else if (config.transactionDurabilityLevel() != TransactionDurabilityLevel.NONE) {
            opts.durability(config.durabilityLevel());
        }
        return opts;
    }

    public static RemoveOptions wrap(RemoveOptions opts, SpanWrapper pspan, TransactionConfig config, PerTransactionConfig perTxn, Core core) {
        opts.timeout(OptionsWrapperUtil.kvTimeoutMutating(config, core));
        if (perTxn.durabilityLevel().isPresent()) {
            DurabilityLevel dl = OptionsWrapperUtil.convert(perTxn.durabilityLevel().get());
            opts.durability(dl);
        } else if (config.transactionDurabilityLevel() != TransactionDurabilityLevel.NONE) {
            opts.durability(config.durabilityLevel());
        }
        return opts;
    }

    public static RemoveOptions wrap(RemoveOptions opts, SpanWrapper pspan, TransactionConfig config, Core core) {
        return OptionsWrapperUtil.wrap(opts, config, Optional.empty(), core);
    }

    public static RemoveOptions wrap(RemoveOptions opts, TransactionConfig config, Optional<DurabilityLevel> override, Core core) {
        opts.timeout(OptionsWrapperUtil.kvTimeoutMutating(config, core));
        if (override.isPresent()) {
            opts.durability(override.get());
        } else if (config.transactionDurabilityLevel() != TransactionDurabilityLevel.NONE) {
            opts.durability(config.durabilityLevel());
        }
        return opts;
    }

    public static MutateInOptions wrap(MutateInOptions opts, SpanWrapper pspan, TransactionConfig config, PerTransactionConfig perTxn, Core core) {
        opts.timeout(OptionsWrapperUtil.kvTimeoutMutating(config, core));
        if (perTxn.durabilityLevel().isPresent()) {
            DurabilityLevel dl = OptionsWrapperUtil.convert(perTxn.durabilityLevel().get());
            opts.durability(dl);
        } else if (config.transactionDurabilityLevel() != TransactionDurabilityLevel.NONE) {
            opts.durability(config.durabilityLevel());
        }
        return opts;
    }

    public static MutateInOptions wrap(MutateInOptions opts, SpanWrapper pspan, TransactionConfig config, Core core) {
        return OptionsWrapperUtil.wrap(opts, config, Optional.empty(), core);
    }

    public static MutateInOptions wrap(MutateInOptions opts, TransactionConfig config, Optional<DurabilityLevel> override, Core core) {
        opts.timeout(OptionsWrapperUtil.kvTimeoutMutating(config, core));
        if (override.isPresent()) {
            opts.durability(override.get());
        } else if (config.transactionDurabilityLevel() != TransactionDurabilityLevel.NONE) {
            opts.durability(config.durabilityLevel());
        }
        return opts;
    }

    private static DurabilityLevel convert(TransactionDurabilityLevel dl) {
        switch (dl) {
            case MAJORITY: {
                return DurabilityLevel.MAJORITY;
            }
            case PERSIST_TO_MAJORITY: {
                return DurabilityLevel.PERSIST_TO_MAJORITY;
            }
            case MAJORITY_AND_PERSIST_TO_ACTIVE: {
                return DurabilityLevel.MAJORITY_AND_PERSIST_TO_ACTIVE;
            }
        }
        return DurabilityLevel.NONE;
    }

    public static MutateInOptions wrap(SpanWrapper pspan, TransactionConfig config, PerTransactionConfig perTxn, Core core) {
        return OptionsWrapperUtil.wrap(MutateInOptions.mutateInOptions(), pspan, config, perTxn, core);
    }

    public static Map<String, Object> createClientContext(String op) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("txn.op", op);
        return map;
    }

    public static Map<String, Object> createClientContext(@Nullable JsonArray params) {
        Map<String, Object> map = OptionsWrapperUtil.createClientContext("query");
        if (params != null) {
            map.put("params", RedactableArgument.redactMeta((Object)params.toString()));
        }
        return map;
    }
}

