/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.support;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.transactions.TransactionGetResult;
import com.couchbase.transactions.config.TransactionConfig;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

@Stability.Internal
public class SpanWrapper {
    AtomicReference<Long> startTime = new AtomicReference<Long>(0L);
    private boolean finished;

    public SpanWrapper start() {
        this.startTime.set(System.nanoTime());
        return this;
    }

    public long finish() {
        if (this.finished) assert (false);
        this.finished = true;
        long elapsed = System.nanoTime() - this.startTime.get();
        return elapsed / 1000000L;
    }

    public SpanWrapper withTag(String key, String value) {
        return this;
    }

    public static SpanWrapper create() {
        return new SpanWrapper();
    }

    public static SpanWrapper create(TransactionConfig config, String op) {
        return SpanWrapper.create(config, op, Optional.empty());
    }

    public static SpanWrapper create(TransactionConfig config, String op, Optional<SpanWrapper> parent) {
        return new SpanWrapper();
    }

    public static SpanWrapper create(TransactionConfig config, String op, SpanWrapper parent) {
        return new SpanWrapper();
    }

    public static SpanWrapper create(TransactionConfig config, ReactiveCollection collection, String op, String id, SpanWrapper parent) {
        return new SpanWrapper();
    }

    public static SpanWrapper create(TransactionConfig config, TransactionGetResult doc, String op, SpanWrapper parent) {
        return new SpanWrapper();
    }

    public static SpanWrapper createATROp(TransactionConfig config, Optional<ReactiveCollection> atrCollection, Optional<String> atrId, String op, SpanWrapper parent) {
        return new SpanWrapper();
    }
}

