/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.ErrorCodeAndMessage;
import com.couchbase.client.core.error.context.QueryErrorContext;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.transactions.error.internal.ErrorClasses;

@Stability.Internal
public class LogDeferThrowable {
    private final Throwable err;

    public LogDeferThrowable(Throwable err) {
        this.err = err;
    }

    public String toString() {
        CouchbaseException ce;
        ErrorClasses ec = ErrorClasses.classify(this.err);
        StringBuilder sb = new StringBuilder();
        sb.append("{err=");
        sb.append(this.err.getClass().getSimpleName());
        sb.append(",ec=");
        sb.append((Object)ec);
        sb.append(",msg='");
        sb.append(RedactableArgument.redactUser((Object)this.err.getMessage()));
        sb.append('\'');
        if (this.err instanceof CouchbaseException && (ce = (CouchbaseException)this.err).context() instanceof QueryErrorContext) {
            QueryErrorContext ctx = (QueryErrorContext)ce.context();
            for (ErrorCodeAndMessage e : ctx.errors()) {
                sb.append(",code=");
                sb.append(e.code());
                sb.append(",msg='");
                sb.append(RedactableArgument.redactUser((Object)e.message()));
                sb.append('\'');
            }
        }
        sb.append("}");
        return sb.toString();
    }
}

