/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.transactions.TransactionAttempt;
import com.couchbase.transactions.config.MergedTransactionConfig;
import com.couchbase.transactions.deferred.TransactionSerializedContext;
import com.couchbase.transactions.log.TransactionLogger;
import com.couchbase.transactions.support.SpanWrapper;
import com.couchbase.transactions.support.SpanWrapperUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@Stability.Internal
public class TransactionContext {
    private final Duration startTimeClient;
    private final Duration deferredElapsed;
    private final List<TransactionAttempt> attempts = new ArrayList<TransactionAttempt>();
    public final TransactionLogger LOGGER;
    private final String transactionId;
    private final SpanWrapper transactionSpan;
    private final EventBus eventBus;
    private final MergedTransactionConfig config;
    @Stability.Volatile
    private Optional<TransactionSerializedContext> serialized = Optional.empty();

    public TransactionContext(RequestTracer tracer, EventBus eventBus, String transactionId, Duration now, Duration deferredElapsed, MergedTransactionConfig config) {
        Objects.requireNonNull(transactionId);
        Objects.requireNonNull(now);
        Objects.requireNonNull(deferredElapsed);
        Objects.requireNonNull(config);
        Objects.requireNonNull(eventBus);
        this.config = config;
        this.eventBus = eventBus;
        SpanWrapper pspan = config.parentSpan().map(sp -> new SpanWrapper(tracer, (RequestSpan)sp)).orElse(null);
        this.transactionSpan = SpanWrapperUtil.basic(SpanWrapper.create(tracer, "transaction", pspan), "transaction").attribute("db.couchbase.transactions.transaction_id", transactionId);
        this.transactionId = transactionId;
        this.startTimeClient = now;
        this.deferredElapsed = deferredElapsed;
        this.LOGGER = new TransactionLogger(eventBus, transactionId, config.logDirectly(), config.logDirectlyLevel().orElse(Event.Severity.INFO));
    }

    public Duration expirationTime() {
        return this.config.expirationTime();
    }

    public long timeSinceStartOfTransactionsMillis(long now) {
        long expiredNanos = now - this.startTimeClient.toNanos() + this.deferredElapsed.toNanos();
        return TimeUnit.NANOSECONDS.toMillis(expiredNanos);
    }

    public boolean hasExpiredClientSide() {
        boolean isExpired;
        long now = System.nanoTime();
        long expiredMillis = this.timeSinceStartOfTransactionsMillis(now);
        boolean bl = isExpired = expiredMillis > this.expirationTime().toMillis();
        if (isExpired) {
            this.LOGGER.info("Has expired client side (now=%dns start=%dns deferredElapsed=%dns expired=%dmillis config=%dms)", now, this.startTimeClient.toNanos(), this.deferredElapsed.toNanos(), expiredMillis, this.expirationTime().toMillis());
        }
        return isExpired;
    }

    public void addAttempt(TransactionAttempt attempt) {
        this.attempts.add(attempt);
    }

    public int numAttempts() {
        return this.attempts.size();
    }

    public List<TransactionAttempt> attempts() {
        return new ArrayList<TransactionAttempt>(this.attempts);
    }

    public String transactionId() {
        return this.transactionId;
    }

    public Duration startTimeClient() {
        return this.startTimeClient;
    }

    public SpanWrapper span() {
        return this.transactionSpan;
    }

    public Optional<TransactionSerializedContext> serialized() {
        return this.serialized;
    }

    public void serialized(TransactionSerializedContext serialized) {
        this.serialized = Optional.of(serialized);
    }
}

