/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryProfile;
import com.couchbase.client.java.query.QueryScanConsistency;
import java.time.Duration;

public class TransactionQueryOptions {
    private QueryOptions builder = QueryOptions.queryOptions().metrics(true);

    protected TransactionQueryOptions() {
    }

    public static TransactionQueryOptions queryOptions() {
        return new TransactionQueryOptions();
    }

    public TransactionQueryOptions raw(String key, Object value) {
        this.builder.raw(key, value);
        return this;
    }

    public TransactionQueryOptions adhoc(boolean adhoc) {
        this.builder.adhoc(adhoc);
        return this;
    }

    public TransactionQueryOptions scanConsistency(QueryScanConsistency scanConsistency) {
        this.builder.scanConsistency(scanConsistency);
        if (scanConsistency == QueryScanConsistency.NOT_BOUNDED) {
            this.builder.raw("scan_consistency", (Object)QueryScanConsistency.NOT_BOUNDED.toString());
        }
        return this;
    }

    public TransactionQueryOptions serializer(JsonSerializer serializer) {
        this.builder.serializer(serializer);
        return this;
    }

    public TransactionQueryOptions profile(QueryProfile profile) {
        this.builder.profile(profile);
        return this;
    }

    public TransactionQueryOptions clientContextId(String clientContextId) {
        this.builder.clientContextId(clientContextId);
        return this;
    }

    public TransactionQueryOptions scanWait(Duration wait) {
        this.builder.scanWait(wait);
        return this;
    }

    public TransactionQueryOptions readonly(boolean readonly) {
        this.builder.readonly(readonly);
        return this;
    }

    public TransactionQueryOptions scanCap(int scanCap) {
        this.builder.scanCap(scanCap);
        return this;
    }

    public TransactionQueryOptions pipelineBatch(int pipelineBatch) {
        this.builder.pipelineBatch(pipelineBatch);
        return this;
    }

    public TransactionQueryOptions pipelineCap(int pipelineCap) {
        this.builder.pipelineCap(pipelineCap);
        return this;
    }

    public TransactionQueryOptions parameters(JsonObject named) {
        this.builder.parameters(named);
        return this;
    }

    public TransactionQueryOptions parameters(JsonArray positional) {
        this.builder.parameters(positional);
        return this;
    }

    public TransactionQueryOptions flexIndex(boolean flexIndex) {
        this.builder.flexIndex(flexIndex);
        return this;
    }

    @Stability.Internal
    QueryOptions builder() {
        return this.builder;
    }
}

