/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.java.kv.MutationState;
import com.couchbase.transactions.TransactionAttempt;
import com.couchbase.transactions.deferred.TransactionSerializedContext;
import com.couchbase.transactions.log.TransactionLogger;
import com.couchbase.transactions.support.AttemptStates;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TransactionResult {
    private final List<TransactionAttempt> attempts;
    private final TransactionLogger log;
    private final Duration timeTaken;
    private final String transactionId;
    private final Optional<TransactionSerializedContext> serialized;

    TransactionResult(List<TransactionAttempt> attempts, TransactionLogger log, Duration timeTaken, String transactionId, Optional<TransactionSerializedContext> serialized) {
        Objects.requireNonNull(attempts);
        Objects.requireNonNull(log);
        Objects.requireNonNull(transactionId);
        Objects.requireNonNull(serialized);
        this.attempts = attempts;
        this.log = log;
        this.timeTaken = timeTaken;
        this.transactionId = transactionId;
        this.serialized = serialized;
    }

    public TransactionLogger log() {
        return this.log;
    }

    @Deprecated
    public List<TransactionAttempt> attempts() {
        return this.attempts;
    }

    public Duration timeTaken() {
        return this.timeTaken;
    }

    public String transactionId() {
        return this.transactionId;
    }

    public List<MutationToken> mutationTokens() {
        if (this.attempts.size() > 0) {
            return this.attempts.get(this.attempts.size() - 1).mutationTokens();
        }
        return new ArrayList<MutationToken>();
    }

    @Stability.Volatile
    public Optional<TransactionSerializedContext> serialized() {
        return this.serialized;
    }

    public MutationState mutationState() {
        List<MutationToken> mt = this.mutationTokens();
        MutationToken[] mts = mt.toArray(new MutationToken[mt.size()]);
        return MutationState.from((MutationToken[])mts);
    }

    public boolean unstagingComplete() {
        if (this.attempts.size() == 0) {
            return false;
        }
        return this.attempts.get(this.attempts.size() - 1).finalState() == AttemptStates.COMPLETED;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TransactionResult{");
        sb.append("attempts=");
        sb.append(this.attempts.size());
        sb.append(",totalTime=");
        sb.append(this.timeTaken.toMillis());
        sb.append("millis");
        sb.append("}");
        return sb.toString();
    }
}

