/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.cleanup;

import com.couchbase.client.core.cnc.Event;
import com.couchbase.transactions.cleanup.CleanupRequest;
import com.couchbase.transactions.cleanup.TransactionsCleanup;
import com.couchbase.transactions.log.TransactionEvent;

public class CleanupFailedEvent
extends TransactionEvent {
    private final CleanupRequest req;
    private final Throwable err;

    public CleanupFailedEvent(CleanupRequest req, Throwable err) {
        super(Event.Severity.VERBOSE, TransactionsCleanup.CATEGORY);
        this.req = req;
        this.err = err;
    }

    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append("Transaction cleanup attempt threw");
        sb.append(", err='");
        sb.append(this.err.toString());
        sb.append("', ATR=");
        sb.append(this.req.atrId());
        sb.append(", attempt=");
        sb.append(this.req.attemptId());
        return sb.toString();
    }

    @Override
    public boolean success() {
        return false;
    }
}

