/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.components;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.transactions.components.DocRecord;
import com.couchbase.transactions.forwards.ForwardCompatibility;
import com.couchbase.transactions.support.AttemptStates;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Stability.Internal
public class ATREntry {
    private final String atrBucket;
    private final String atrId;
    private final String attemptId;
    private final Optional<String> transactionId;
    private final AttemptStates state;
    private final Optional<Long> timestampStartMsecs;
    private final Optional<Long> timestampCommitMsecs;
    private final Optional<Long> timestampCompleteMsecs;
    private final Optional<Long> timestampRollBackMsecs;
    private final Optional<Long> timestampRolledBackMsecs;
    private final Optional<Integer> expiresAfterMsecs;
    private final long cas;
    private final Optional<List<DocRecord>> insertedIds;
    private final Optional<List<DocRecord>> replacedIds;
    private final Optional<List<DocRecord>> removedIds;
    private final Optional<ForwardCompatibility> forwardCompatibility;
    private final Optional<DurabilityLevel> durabilityLevel;

    public ATREntry(String atrBucket, String atrId, String attemptId, Optional<String> transactionId, AttemptStates state, Optional<Long> timestampStartMsecs, Optional<Long> timestampCommitMsecs, Optional<Long> timestampCompleteMsecs, Optional<Long> timestampRollBackMsecs, Optional<Long> timestampRolledBackMsecs, Optional<Integer> expiresAfterMsecs, Optional<List<DocRecord>> insertedIds, Optional<List<DocRecord>> replacedIds, Optional<List<DocRecord>> removedIds, long cas, Optional<ForwardCompatibility> forwardCompatibility, Optional<DurabilityLevel> durabilityLevel) {
        Objects.requireNonNull(atrBucket);
        Objects.requireNonNull(atrId);
        Objects.requireNonNull(attemptId);
        Objects.requireNonNull(state);
        Objects.requireNonNull(timestampStartMsecs);
        Objects.requireNonNull(timestampCommitMsecs);
        Objects.requireNonNull(timestampCompleteMsecs);
        Objects.requireNonNull(timestampRollBackMsecs);
        Objects.requireNonNull(timestampRolledBackMsecs);
        Objects.requireNonNull(insertedIds);
        Objects.requireNonNull(replacedIds);
        Objects.requireNonNull(removedIds);
        Objects.requireNonNull(expiresAfterMsecs);
        Objects.requireNonNull(forwardCompatibility);
        Objects.requireNonNull(durabilityLevel);
        this.atrId = atrId;
        this.atrBucket = atrBucket;
        this.attemptId = attemptId;
        this.transactionId = transactionId;
        this.state = state;
        this.timestampStartMsecs = timestampStartMsecs;
        this.timestampCommitMsecs = timestampCommitMsecs;
        this.timestampCompleteMsecs = timestampCompleteMsecs;
        this.timestampRollBackMsecs = timestampRollBackMsecs;
        this.timestampRolledBackMsecs = timestampRolledBackMsecs;
        this.expiresAfterMsecs = expiresAfterMsecs;
        this.cas = cas;
        this.insertedIds = insertedIds;
        this.replacedIds = replacedIds;
        this.removedIds = removedIds;
        this.forwardCompatibility = forwardCompatibility;
        this.durabilityLevel = durabilityLevel;
    }

    public boolean hasExpired() {
        return this.hasExpired(0L);
    }

    public boolean hasExpired(long safetyMarginMillis) {
        long casInMsecs = this.cas / 1000000L;
        if (!this.expiresAfterMsecs.isPresent()) {
            return false;
        }
        return this.hasExpired(casInMsecs, (long)this.expiresAfterMsecs.get().intValue() + safetyMarginMillis);
    }

    public boolean hasExpired(long cas, long txnExpiresAfterMsecs) {
        if (this.timestampStartMsecs.isPresent()) {
            return cas - this.timestampStartMsecs.get() > txnExpiresAfterMsecs;
        }
        return false;
    }

    public long ageMsecs() {
        return this.cas / 1000000L - this.timestampStartMsecs().orElse(0L);
    }

    public String atrId() {
        return this.atrId;
    }

    public String attemptId() {
        return this.attemptId;
    }

    public Optional<String> transactionId() {
        return this.transactionId;
    }

    public AttemptStates state() {
        return this.state;
    }

    public Optional<Long> timestampStartMsecs() {
        return this.timestampStartMsecs;
    }

    public Optional<Long> timestampCommitMsecs() {
        return this.timestampCommitMsecs;
    }

    public Optional<Long> timestampCompleteMsecs() {
        return this.timestampCompleteMsecs;
    }

    public Optional<Long> timestampRollBackMsecs() {
        return this.timestampRollBackMsecs;
    }

    public Optional<Long> timestampRolledBackMsecs() {
        return this.timestampRolledBackMsecs;
    }

    public long cas() {
        return this.cas;
    }

    public Optional<List<DocRecord>> insertedIds() {
        return this.insertedIds;
    }

    public Optional<List<DocRecord>> replacedIds() {
        return this.replacedIds;
    }

    public Optional<List<DocRecord>> removedIds() {
        return this.removedIds;
    }

    public Optional<Integer> expiresAfterMsecs() {
        return this.expiresAfterMsecs;
    }

    public Optional<ForwardCompatibility> forwardCompatibility() {
        return this.forwardCompatibility;
    }

    public Optional<DurabilityLevel> durabilityLevel() {
        return this.durabilityLevel;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ATREntry{");
        sb.append("atr=").append(this.atrBucket).append('/').append(this.atrId);
        sb.append(",attemptId=").append(this.attemptId);
        sb.append(",state=").append((Object)this.state);
        sb.append(",expires=").append(this.expiresAfterMsecs).append("ms");
        sb.append(",[age=").append(this.ageMsecs()).append("ms");
        long casInMsecs = this.cas / 1000000L;
        sb.append(",cas=").append(this.cas);
        sb.append("ns/");
        sb.append(casInMsecs);
        sb.append("ms],inserted=").append(this.insertedIds);
        sb.append(",replaced=").append(this.replacedIds);
        sb.append(",removed=").append(this.removedIds);
        sb.append(",start=").append(this.timestampStartMsecs).append("ms");
        sb.append(",fc=").append(this.forwardCompatibility.map(Object::toString).orElse("none"));
        sb.append(",dl=").append(this.durabilityLevel.map(Object::toString).orElse("n/a"));
        sb.append('}');
        return sb.toString();
    }
}

