/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.query.QueryScanConsistency;
import com.couchbase.transactions.TransactionDurabilityLevel;
import com.couchbase.transactions.cleanup.CleanerFactory;
import com.couchbase.transactions.cleanup.ClientRecordFactory;
import com.couchbase.transactions.config.PerTransactionConfig;
import com.couchbase.transactions.config.TransactionConfig;
import com.couchbase.transactions.support.AttemptContextFactory;
import com.couchbase.transactions.support.OptionsWrapperUtil;
import java.time.Duration;
import java.util.Optional;

@Stability.Internal
public class MergedTransactionConfig {
    private final TransactionConfig config;
    private final Optional<PerTransactionConfig> perConfig;

    public MergedTransactionConfig(TransactionConfig config) {
        this(config, Optional.empty());
    }

    public MergedTransactionConfig(TransactionConfig config, Optional<PerTransactionConfig> perConfig) {
        this.config = config;
        this.perConfig = perConfig;
    }

    public Optional<QueryScanConsistency> scanConsistency() {
        if (this.perConfig.flatMap(PerTransactionConfig::scanConsistency).isPresent()) {
            return this.perConfig.flatMap(PerTransactionConfig::scanConsistency);
        }
        return this.config.scanConsistency();
    }

    public Optional<RequestSpan> parentSpan() {
        return this.perConfig.flatMap(PerTransactionConfig::parentSpan);
    }

    public Duration expirationTime() {
        return this.perConfig.flatMap(PerTransactionConfig::expirationTime).orElse(this.config.transactionExpirationTime());
    }

    public Optional<Duration> keyValueTimeout() {
        if (this.perConfig.flatMap(PerTransactionConfig::keyValueTimeout).isPresent()) {
            return this.perConfig.flatMap(PerTransactionConfig::keyValueTimeout);
        }
        return this.config.keyValueTimeout();
    }

    public boolean logDirectly() {
        return this.config.logDirectlyLevel().isPresent();
    }

    public Optional<Event.Severity> logDirectlyLevel() {
        return this.config.logDirectlyLevel();
    }

    public boolean runLostAttemptsCleanupThread() {
        return this.config.runLostAttemptsCleanupThread();
    }

    public boolean runRegularAttemptsCleanupThread() {
        return this.config.runRegularAttemptsCleanupThread();
    }

    public Duration cleanupWindow() {
        return this.config.cleanupWindow();
    }

    public boolean logOnFailure() {
        return this.config.logOnFailure();
    }

    public Event.Severity logOnFailureLevel() {
        return this.config.logOnFailureLevel();
    }

    public TransactionDurabilityLevel transactionDurabilityLevel() {
        if (this.perConfig.flatMap(PerTransactionConfig::durabilityLevel).isPresent()) {
            return (TransactionDurabilityLevel)((Object)this.perConfig.flatMap(PerTransactionConfig::durabilityLevel).get());
        }
        return this.config.transactionDurabilityLevel();
    }

    public DurabilityLevel durabilityLevel() {
        return OptionsWrapperUtil.convert(this.transactionDurabilityLevel());
    }

    public AttemptContextFactory attemptContextFactory() {
        return this.config.attemptContextFactory();
    }

    public CleanerFactory cleanerFactory() {
        return this.config.cleanerFactory();
    }

    public ClientRecordFactory clientRecordFactory() {
        return this.config.clientRecordFactory();
    }

    public Optional<Collection> persistentLoggingCollection() {
        return this.config.persistentLoggingCollection();
    }

    public int numAtrs() {
        return this.config.numAtrs();
    }

    public Optional<Collection> metadataCollection() {
        return this.config.metadataCollection();
    }
}

