/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.transactions.TransactionDurabilityLevel;
import com.couchbase.transactions.TransactionQueryOptions;
import com.couchbase.transactions.config.PerTransactionConfig;
import com.couchbase.transactions.config.PerTransactionConfigBuilder;
import java.time.Duration;
import java.util.Optional;

public class SingleQueryTransactionConfig {
    private final Optional<RequestSpan> parentSpan;
    private final TransactionQueryOptions queryOptions;
    private final Optional<TransactionDurabilityLevel> durabilityLevel;
    private final Optional<Duration> expirationTime;

    public Optional<RequestSpan> parentSpan() {
        return this.parentSpan;
    }

    public TransactionQueryOptions queryOptions() {
        return this.queryOptions;
    }

    public Optional<TransactionDurabilityLevel> durabilityLevel() {
        return this.durabilityLevel;
    }

    public Optional<Duration> expirationTime() {
        return this.expirationTime;
    }

    public SingleQueryTransactionConfig(Optional<RequestSpan> parentSpan, TransactionQueryOptions queryOptions, Optional<TransactionDurabilityLevel> durabilityLevel, Optional<Duration> expirationTime) {
        this.parentSpan = parentSpan;
        this.queryOptions = queryOptions;
        this.durabilityLevel = durabilityLevel;
        this.expirationTime = expirationTime;
    }

    @Stability.Internal
    public PerTransactionConfig convert() {
        PerTransactionConfigBuilder out = PerTransactionConfigBuilder.create();
        this.parentSpan.ifPresent(v -> out.parentSpan((RequestSpan)v));
        this.durabilityLevel.ifPresent(v -> out.durabilityLevel((TransactionDurabilityLevel)((Object)v)));
        this.expirationTime.ifPresent(v -> out.expirationTime((Duration)v));
        return out.build();
    }
}

