/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.error.attempts;

import com.couchbase.transactions.AttemptContextReactive;
import com.couchbase.transactions.TransactionGetResult;
import com.couchbase.transactions.error.attempts.AttemptException;
import com.couchbase.transactions.util.DebugUtil;

public class DocumentAlreadyInTransaction
extends AttemptException {
    private final TransactionGetResult doc;

    private DocumentAlreadyInTransaction(AttemptContextReactive ctx, TransactionGetResult doc, String msg) {
        super(ctx, msg);
        this.doc = doc;
    }

    public static DocumentAlreadyInTransaction create(AttemptContextReactive ctx, TransactionGetResult doc) {
        StringBuilder msg = new StringBuilder();
        msg.append("Document ");
        msg.append(DebugUtil.docId(doc));
        msg.append(" is already in a transaction, atr=");
        msg.append(doc.links().atrBucketName().orElse("-"));
        msg.append('/');
        msg.append(doc.links().atrId().orElse("-"));
        msg.append(" attemptId=");
        msg.append(doc.links().stagedAttemptId().orElse("-"));
        return new DocumentAlreadyInTransaction(ctx, doc, msg.toString());
    }

    public String docId() {
        return this.doc.id();
    }

    public TransactionGetResult doc() {
        return this.doc;
    }
}

