/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.error.external;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.transactions.AttemptContextReactive;
import com.couchbase.transactions.error.RetryTransaction;
import com.couchbase.transactions.error.internal.ErrorClasses;
import com.couchbase.transactions.error.internal.TransactionOperationFailedBuilder;
import com.couchbase.transactions.util.DebugUtil;

@Stability.Volatile
public class TransactionOperationFailed
extends RuntimeException {
    private final AttemptContextReactive ctx;
    private final ErrorClasses causingErrorClass;
    private final boolean autoRollbackAttempt;
    private final boolean retryTransaction;
    private final FinalErrorToRaise toRaise;

    public TransactionOperationFailed(AttemptContextReactive ctx, ErrorClasses causingErrorClass, boolean autoRollbackAttempt, boolean retryTransaction, Throwable cause, FinalErrorToRaise toRaise) {
        super(cause);
        this.ctx = ctx;
        this.causingErrorClass = causingErrorClass;
        this.autoRollbackAttempt = autoRollbackAttempt;
        this.retryTransaction = retryTransaction;
        this.toRaise = toRaise;
    }

    @Stability.Internal
    public ErrorClasses causingErrorClass() {
        return this.causingErrorClass;
    }

    @Stability.Internal
    public boolean autoRollbackAttempt() {
        return this.autoRollbackAttempt;
    }

    @Stability.Internal
    public boolean retryTransaction() {
        return this.retryTransaction;
    }

    @Stability.Internal
    public AttemptContextReactive context() {
        return this.ctx;
    }

    @Stability.Internal
    public FinalErrorToRaise toRaise() {
        return this.toRaise;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TransactionOperationFailed {");
        sb.append("ec:");
        sb.append((Object)this.causingErrorClass);
        if (this.getCause() != null) {
            sb.append(", cause:");
            sb.append(RedactableArgument.redactUser((Object)this.getCause().getClass().getName()));
        }
        sb.append(", retry:");
        sb.append(this.retryTransaction);
        sb.append(", autoRollback:");
        sb.append(this.autoRollbackAttempt);
        if (!this.retryTransaction) {
            sb.append(", raise:");
            sb.append((Object)this.toRaise);
        }
        sb.append("}");
        return sb.toString();
    }

    @Stability.Internal
    public static TransactionOperationFailed convertToOperationFailedIfNeeded(Throwable e, AttemptContextReactive ctx) {
        if (e instanceof TransactionOperationFailed) {
            return (TransactionOperationFailed)e;
        }
        TransactionOperationFailedBuilder builder = TransactionOperationFailedBuilder.createError(ctx, ErrorClasses.classify(e)).cause(e);
        if (e instanceof RetryTransaction) {
            builder.retryTransaction();
        }
        TransactionOperationFailed out = builder.build();
        ctx.logger().info(ctx.attemptId(), "Caught exception from application's lambda %s, converted it to %s", DebugUtil.dbg(e), DebugUtil.dbg(out));
        return out;
    }

    @Stability.Internal
    public static enum FinalErrorToRaise {
        TRANSACTION_FAILED,
        TRANSACTION_EXPIRED,
        TRANSACTION_COMMIT_AMBIGUOUS,
        TRANSACTION_FAILED_POST_COMMIT;

    }
}

