/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.error.internal;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.AmbiguousTimeoutException;
import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.DocumentExistsException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.DurabilityAmbiguousException;
import com.couchbase.client.core.error.DurableWriteInProgressException;
import com.couchbase.client.core.error.RequestCanceledException;
import com.couchbase.client.core.error.TemporaryFailureException;
import com.couchbase.client.core.error.UnambiguousTimeoutException;
import com.couchbase.client.core.error.ValueTooLargeException;
import com.couchbase.client.core.error.subdoc.PathExistsException;
import com.couchbase.client.core.error.subdoc.PathNotFoundException;
import com.couchbase.transactions.error.attempts.DocumentAlreadyInTransaction;
import com.couchbase.transactions.error.external.TransactionOperationFailed;
import com.couchbase.transactions.error.internal.AbortedAsRequestedNoRollback;
import com.couchbase.transactions.error.internal.AbortedAsRequestedNoRollbackNoCleanup;
import com.couchbase.transactions.error.internal.AttemptExpired;
import com.couchbase.transactions.error.internal.ErrorClassException;
import com.couchbase.transactions.error.internal.TestFailAmbiguous;
import com.couchbase.transactions.error.internal.TestFailHard;
import com.couchbase.transactions.error.internal.TestFailTransient;

@Stability.Internal
public enum ErrorClasses {
    TRANSACTION_OPERATION_FAILED,
    FAIL_TRANSIENT,
    FAIL_HARD,
    FAIL_OTHER,
    FAIL_AMBIGUOUS,
    FAIL_DOC_ALREADY_EXISTS,
    FAIL_DOC_NOT_FOUND,
    FAIL_PATH_ALREADY_EXISTS,
    FAIL_PATH_NOT_FOUND,
    FAIL_CAS_MISMATCH,
    FAIL_EXPIRY,
    FAIL_WRITE_WRITE_CONFLICT,
    FAIL_ATR_FULL;


    public static ErrorClasses classify(Throwable err) {
        if (err instanceof TransactionOperationFailed) {
            return TRANSACTION_OPERATION_FAILED;
        }
        if (err instanceof ErrorClassException) {
            return ((ErrorClassException)err).errorClass();
        }
        if (err instanceof DocumentAlreadyInTransaction) {
            return FAIL_WRITE_WRITE_CONFLICT;
        }
        if (err instanceof DocumentNotFoundException) {
            return FAIL_DOC_NOT_FOUND;
        }
        if (err instanceof DocumentExistsException) {
            return FAIL_DOC_ALREADY_EXISTS;
        }
        if (err instanceof PathExistsException) {
            return FAIL_PATH_ALREADY_EXISTS;
        }
        if (err instanceof PathNotFoundException) {
            return FAIL_PATH_NOT_FOUND;
        }
        if (err instanceof CasMismatchException) {
            return FAIL_CAS_MISMATCH;
        }
        if (ErrorClasses.isFailTransient(err)) {
            return FAIL_TRANSIENT;
        }
        if (ErrorClasses.isFailAmbiguous(err)) {
            return FAIL_AMBIGUOUS;
        }
        if (ErrorClasses.isFailHard(err)) {
            return FAIL_HARD;
        }
        if (err instanceof AttemptExpired) {
            return FAIL_EXPIRY;
        }
        if (err instanceof ValueTooLargeException) {
            return FAIL_ATR_FULL;
        }
        return FAIL_OTHER;
    }

    public static boolean isFailTransient(Throwable e) {
        return e instanceof CasMismatchException || e instanceof UnambiguousTimeoutException || e instanceof TemporaryFailureException || e instanceof DurableWriteInProgressException || e instanceof TestFailTransient;
    }

    public static boolean isFailHard(Throwable e) {
        return e instanceof TestFailHard || e instanceof AbortedAsRequestedNoRollback || e instanceof AbortedAsRequestedNoRollbackNoCleanup || e instanceof AssertionError;
    }

    public static boolean isFailAmbiguous(Throwable e) {
        return e instanceof DurabilityAmbiguousException || e instanceof AmbiguousTimeoutException || e instanceof RequestCanceledException || e instanceof TestFailAmbiguous;
    }

    public static ErrorClasses mapFromQuery(Integer ec) {
        if (ec == null) {
            return FAIL_OTHER;
        }
        switch (ec) {
            case 1: {
                return FAIL_TRANSIENT;
            }
            case 2: {
                return FAIL_DOC_NOT_FOUND;
            }
            case 3: {
                return FAIL_DOC_ALREADY_EXISTS;
            }
            case 4: {
                return FAIL_PATH_NOT_FOUND;
            }
            case 5: {
                return FAIL_PATH_ALREADY_EXISTS;
            }
            case 6: {
                return FAIL_WRITE_WRITE_CONFLICT;
            }
            case 7: {
                return FAIL_CAS_MISMATCH;
            }
            case 8: {
                return FAIL_HARD;
            }
            case 9: {
                return FAIL_AMBIGUOUS;
            }
            case 10: {
                return FAIL_EXPIRY;
            }
            case 11: {
                return FAIL_ATR_FULL;
            }
        }
        return FAIL_OTHER;
    }
}

