/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.error.internal;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.transactions.AttemptContextReactive;
import com.couchbase.transactions.error.external.TransactionOperationFailed;
import com.couchbase.transactions.error.internal.ErrorClasses;

@Stability.Internal
public class TransactionOperationFailedBuilder {
    private final AttemptContextReactive ctx;
    private final ErrorClasses causingErrorClass;
    private boolean rollbackAttempt = true;
    private boolean retryTransaction = false;
    private Throwable cause = null;
    private TransactionOperationFailed.FinalErrorToRaise toRaise = TransactionOperationFailed.FinalErrorToRaise.TRANSACTION_FAILED;

    private TransactionOperationFailedBuilder(AttemptContextReactive ctx, ErrorClasses causingErrorClass) {
        this.ctx = ctx;
        this.causingErrorClass = causingErrorClass;
    }

    public static TransactionOperationFailedBuilder createError(AttemptContextReactive ctx, ErrorClasses causingErrorClass) {
        return new TransactionOperationFailedBuilder(ctx, causingErrorClass);
    }

    public TransactionOperationFailedBuilder raiseException(TransactionOperationFailed.FinalErrorToRaise toRaise) {
        this.toRaise = toRaise;
        return this;
    }

    public TransactionOperationFailedBuilder doNotRollbackAttempt() {
        this.rollbackAttempt = false;
        return this;
    }

    public TransactionOperationFailedBuilder rollbackAttempt(boolean value) {
        this.rollbackAttempt = value;
        return this;
    }

    public TransactionOperationFailedBuilder retryTransaction() {
        this.retryTransaction = true;
        return this;
    }

    public TransactionOperationFailedBuilder cause(Throwable cause) {
        this.cause = cause;
        return this;
    }

    public TransactionOperationFailed build() {
        return new TransactionOperationFailed(this.ctx, this.causingErrorClass, this.rollbackAttempt, this.retryTransaction, this.cause, this.toRaise);
    }
}

