/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.support;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.kv.InsertOptions;
import com.couchbase.client.java.kv.MutateInOptions;
import com.couchbase.client.java.kv.RemoveOptions;
import com.couchbase.transactions.TransactionDurabilityLevel;
import com.couchbase.transactions.components.SerializationUtil;
import com.couchbase.transactions.config.MergedTransactionConfig;
import com.couchbase.transactions.support.SpanWrapper;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class OptionsWrapperUtil {
    private OptionsWrapperUtil() {
    }

    public static Duration kvTimeoutNonMutating(MergedTransactionConfig config, Core core) {
        return config.keyValueTimeout().orElse(core.context().environment().timeoutConfig().kvTimeout());
    }

    public static Duration kvTimeoutMutating(MergedTransactionConfig config, Core core) {
        return config.keyValueTimeout().orElse(core.context().environment().timeoutConfig().kvDurableTimeout());
    }

    public static InsertOptions wrap(InsertOptions opts, SpanWrapper pspan, MergedTransactionConfig config, Core core) {
        ((InsertOptions)opts.timeout(OptionsWrapperUtil.kvTimeoutMutating(config, core))).transcoder((Transcoder)SerializationUtil.DEFAULT_TRANSCODER).parentSpan(pspan.span());
        if (config.transactionDurabilityLevel() != TransactionDurabilityLevel.NONE) {
            opts.durability(OptionsWrapperUtil.convert(config.transactionDurabilityLevel()));
        }
        return opts;
    }

    public static InsertOptions wrap(InsertOptions opts, MergedTransactionConfig config, Optional<DurabilityLevel> override, Core core, SpanWrapper pspan) {
        ((InsertOptions)opts.timeout(OptionsWrapperUtil.kvTimeoutMutating(config, core))).transcoder((Transcoder)SerializationUtil.DEFAULT_TRANSCODER).parentSpan(pspan.span());
        if (override.isPresent()) {
            opts.durability(override.get());
        } else if (config.transactionDurabilityLevel() != TransactionDurabilityLevel.NONE) {
            opts.durability(OptionsWrapperUtil.convert(config.transactionDurabilityLevel()));
        }
        return opts;
    }

    public static RemoveOptions wrap(RemoveOptions opts, SpanWrapper pspan, MergedTransactionConfig config, Core core) {
        ((RemoveOptions)opts.timeout(OptionsWrapperUtil.kvTimeoutMutating(config, core))).parentSpan(pspan.span());
        if (config.transactionDurabilityLevel() != TransactionDurabilityLevel.NONE) {
            opts.durability(OptionsWrapperUtil.convert(config.transactionDurabilityLevel()));
        }
        return opts;
    }

    public static RemoveOptions wrap(RemoveOptions opts, MergedTransactionConfig config, Optional<DurabilityLevel> override, Core core, SpanWrapper pspan) {
        ((RemoveOptions)opts.timeout(OptionsWrapperUtil.kvTimeoutMutating(config, core))).parentSpan(pspan.span());
        if (override.isPresent()) {
            opts.durability(override.get());
        } else if (config.transactionDurabilityLevel() != TransactionDurabilityLevel.NONE) {
            opts.durability(OptionsWrapperUtil.convert(config.transactionDurabilityLevel()));
        }
        return opts;
    }

    public static MutateInOptions wrap(MutateInOptions opts, SpanWrapper pspan, MergedTransactionConfig config, Core core) {
        ((MutateInOptions)opts.timeout(OptionsWrapperUtil.kvTimeoutMutating(config, core))).serializer((JsonSerializer)SerializationUtil.DEFAULT_JSON_SERIALIZER).parentSpan(pspan.span());
        if (config.transactionDurabilityLevel() != TransactionDurabilityLevel.NONE) {
            opts.durability(OptionsWrapperUtil.convert(config.transactionDurabilityLevel()));
        }
        return opts;
    }

    public static MutateInOptions wrap(MutateInOptions opts, MergedTransactionConfig config, Optional<DurabilityLevel> override, Core core, SpanWrapper pspan) {
        ((MutateInOptions)opts.timeout(OptionsWrapperUtil.kvTimeoutMutating(config, core))).serializer((JsonSerializer)SerializationUtil.DEFAULT_JSON_SERIALIZER).parentSpan(pspan.span());
        if (override.isPresent()) {
            opts.durability(override.get());
        } else if (config.transactionDurabilityLevel() != TransactionDurabilityLevel.NONE) {
            opts.durability(OptionsWrapperUtil.convert(config.transactionDurabilityLevel()));
        }
        return opts;
    }

    public static DurabilityLevel convert(TransactionDurabilityLevel dl) {
        switch (dl) {
            case MAJORITY: {
                return DurabilityLevel.MAJORITY;
            }
            case PERSIST_TO_MAJORITY: {
                return DurabilityLevel.PERSIST_TO_MAJORITY;
            }
            case MAJORITY_AND_PERSIST_TO_ACTIVE: {
                return DurabilityLevel.MAJORITY_AND_PERSIST_TO_ACTIVE;
            }
        }
        return DurabilityLevel.NONE;
    }

    public static MutateInOptions wrap(SpanWrapper pspan, MergedTransactionConfig config, Core core) {
        return OptionsWrapperUtil.wrap(MutateInOptions.mutateInOptions(), pspan, config, core);
    }

    public static Map<String, Object> createClientContext(String op) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("txn.op", op);
        return map;
    }

    public static Map<String, Object> createClientContext(@Nullable JsonArray params) {
        Map<String, Object> map = OptionsWrapperUtil.createClientContext("query");
        if (params != null) {
            map.put("params", RedactableArgument.redactMeta((Object)params.toString()));
        }
        return map;
    }
}

