/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.support;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import java.util.concurrent.TimeUnit;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class SpanWrapper {
    private final long startTime = System.nanoTime();
    private final RequestSpan span;
    private final RequestTracer tracer;
    private boolean finished = false;

    public long finish() {
        if (!this.finished) {
            this.finished = true;
            long elapsed = System.nanoTime() - this.startTime;
            this.span.end();
            return TimeUnit.NANOSECONDS.toMicros(elapsed);
        }
        return 0L;
    }

    public SpanWrapper(RequestTracer tracer, RequestSpan span) {
        this.tracer = tracer;
        this.span = span;
    }

    public static SpanWrapper create(RequestTracer tracer, String op, @Nullable SpanWrapper parent) {
        RequestSpan span = tracer.requestSpan(op, parent == null ? null : parent.span);
        return new SpanWrapper(tracer, span);
    }

    public <T> SpanWrapper attribute(String key, T value) {
        try {
            this.span.attribute(key, String.valueOf(value));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    public RequestSpan span() {
        return this.span;
    }

    public void failWith(Throwable err) {
        try {
            this.span.status(RequestSpan.StatusCode.ERROR);
            this.span.attribute("error.name", err.getClass().getName());
            this.span.attribute("error.message", err.getMessage());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.finish();
    }
}

