/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.Scope;
import com.couchbase.client.java.query.QueryResult;
import com.couchbase.transactions.AttemptContextReactive;
import com.couchbase.transactions.TransactionGetResult;
import com.couchbase.transactions.TransactionInsertOptions;
import com.couchbase.transactions.TransactionQueryOptions;
import com.couchbase.transactions.TransactionReplaceOptions;
import com.couchbase.transactions.log.TransactionLogger;
import java.util.Objects;
import java.util.Optional;

public class AttemptContext {
    private final AttemptContextReactive reactive;

    AttemptContext(AttemptContextReactive reactive) {
        Objects.requireNonNull(reactive);
        this.reactive = reactive;
    }

    AttemptContextReactive ctx() {
        return this.reactive;
    }

    public TransactionLogger logger() {
        return this.ctx().LOGGER;
    }

    public Optional<TransactionGetResult> getOptional(Collection collection, String id) {
        Optional out = (Optional)this.reactive.getOptional(collection.reactive(), id).block();
        if (out != null) {
            return out;
        }
        return Optional.empty();
    }

    public TransactionGetResult get(Collection collection, String id) {
        return (TransactionGetResult)this.reactive.get(collection.reactive(), id).block();
    }

    public TransactionGetResult replace(TransactionGetResult doc, Object content, TransactionReplaceOptions options) {
        return (TransactionGetResult)this.reactive.replace(doc, content, options).block();
    }

    public TransactionGetResult replace(TransactionGetResult doc, Object content) {
        return (TransactionGetResult)this.reactive.replace(doc, content, TransactionReplaceOptions.DEFAULT).block();
    }

    public TransactionGetResult insert(Collection collection, String id, Object content, TransactionInsertOptions options) {
        return (TransactionGetResult)this.reactive.insert(collection.reactive(), id, content, options).block();
    }

    public TransactionGetResult insert(Collection collection, String id, Object content) {
        return this.insert(collection, id, content, TransactionInsertOptions.DEFAULT);
    }

    public void remove(TransactionGetResult doc) {
        this.reactive.remove(doc).block();
    }

    public void commit() {
        this.reactive.commit().block();
    }

    @Stability.Volatile
    public void defer() {
        this.reactive.defer().block();
    }

    public void rollback() {
        this.reactive.rollback().block();
    }

    public String attemptId() {
        return this.reactive.attemptId();
    }

    public String transactionId() {
        return this.reactive.transactionId();
    }

    @Stability.Uncommitted
    public QueryResult query(String statement, TransactionQueryOptions options) {
        return (QueryResult)this.reactive.queryBlocking(statement, options).block();
    }

    QueryResult query(Scope scope, String statement, TransactionQueryOptions options, boolean tximplicit) {
        return (QueryResult)this.reactive.queryBlocking(scope, statement, options, tximplicit).block();
    }

    @Stability.Uncommitted
    public QueryResult query(String statement) {
        return this.query(statement, TransactionQueryOptions.queryOptions());
    }

    @Stability.Uncommitted
    public QueryResult query(Scope scope, String statement, TransactionQueryOptions options) {
        return (QueryResult)this.reactive.queryBlocking(scope, statement, options, false).block();
    }

    @Stability.Uncommitted
    public QueryResult query(Scope scope, String statement) {
        return this.query(scope, statement, TransactionQueryOptions.queryOptions());
    }
}

