/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.forwards;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.transactions.error.external.ForwardCompatibilityFailure;
import com.couchbase.transactions.error.internal.ForwardCompatibilityRequiresRetry;
import com.couchbase.transactions.forwards.ForwardCompatBehaviour;
import com.couchbase.transactions.forwards.ForwardCompatBehaviourFull;
import com.couchbase.transactions.forwards.ForwardCompatibilityForStage;
import com.couchbase.transactions.forwards.ForwardCompatibilityStages;
import com.couchbase.transactions.forwards.Supported;
import com.couchbase.transactions.log.TransactionLogger;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class ForwardCompatibility {
    private final Map<String, ForwardCompatibilityForStage> compatibilityMap = new HashMap<String, ForwardCompatibilityForStage>();
    private final JsonObject raw;
    private static RuntimeException RETRY = new ForwardCompatibilityRequiresRetry();
    private static RuntimeException NO_RETRY = new ForwardCompatibilityFailure();

    public ForwardCompatibility(JsonObject json) {
        this.raw = json;
        for (String name : json.getNames()) {
            JsonArray a = json.getArray(name);
            this.compatibilityMap.put(name, new ForwardCompatibilityForStage(a));
        }
    }

    public ForwardCompatBehaviourFull check(ForwardCompatibilityStages fc, Supported supported) {
        if (this.compatibilityMap.containsKey(fc.value())) {
            ForwardCompatibilityForStage f = this.compatibilityMap.get(fc.value());
            return f.behaviour(supported);
        }
        return ForwardCompatBehaviourFull.CONTINUE;
    }

    public static Mono<Void> check(ForwardCompatibilityStages fc, Optional<ForwardCompatibility> forwardCompatibility, @Nullable TransactionLogger logger, Supported supported) {
        return Mono.defer(() -> {
            if (forwardCompatibility.isPresent()) {
                RuntimeException toThrow;
                ForwardCompatibility map = (ForwardCompatibility)forwardCompatibility.get();
                ForwardCompatBehaviourFull behaviour = map.check(fc, supported);
                if (behaviour.behaviour == ForwardCompatBehaviour.CONTINUE) {
                    return Mono.empty();
                }
                RuntimeException runtimeException = toThrow = behaviour.behaviour == ForwardCompatBehaviour.RETRY_TRANSACTION ? RETRY : NO_RETRY;
                if (logger != null) {
                    logger.warn("", String.format("forward-compatibility rejection at point '%s'/'%s', map is %s, supported is %s", fc.name(), fc.value(), map.raw, supported));
                }
                if (behaviour.retryAfterMillis.isPresent()) {
                    return Mono.delay((Duration)Duration.ofMillis(behaviour.retryAfterMillis.get().intValue())).then(Mono.error((Throwable)toThrow));
                }
                return Mono.error((Throwable)toThrow);
            }
            return Mono.empty();
        });
    }

    public String toString() {
        return this.raw.toString();
    }
}

