/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.log;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.transactions.cleanup.CleanupRequest;
import com.couchbase.transactions.cleanup.TransactionsCleanup;
import com.couchbase.transactions.log.LogDefer;
import com.couchbase.transactions.log.TransactionEvent;
import java.util.List;

@Stability.Volatile
public class TransactionCleanupAttempt
extends TransactionEvent {
    private final boolean success;
    private final boolean isRegular;
    private final List<LogDefer> logs;
    private final String attemptId;
    private final String atrId;
    private final ReactiveCollection atrCollection;
    private final CleanupRequest req;
    private final String addlDebug;

    public TransactionCleanupAttempt(Event.Severity severity, boolean success, boolean isRegular, List<LogDefer> logs, String attemptId, String atrId, ReactiveCollection atrCollection, CleanupRequest req, String addlDebug) {
        super(severity, TransactionsCleanup.CATEGORY);
        this.success = success;
        this.isRegular = isRegular;
        this.logs = logs;
        this.attemptId = attemptId;
        this.atrId = atrId;
        this.atrCollection = atrCollection;
        this.req = req;
        this.addlDebug = addlDebug;
    }

    @Override
    public List<LogDefer> logs() {
        return this.logs;
    }

    @Override
    public boolean success() {
        return this.success;
    }

    public String attemptId() {
        return this.attemptId;
    }

    public String atrId() {
        return this.atrId;
    }

    @Deprecated
    public String atrBucket() {
        return null;
    }

    public ReactiveCollection atrCollection() {
        return this.atrCollection;
    }

    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append("Transaction cleanup attempt ");
        sb.append(this.success ? "succeeded" : "failed");
        sb.append(", ");
        sb.append(this.addlDebug);
        sb.append("isRegular=");
        sb.append(this.isRegular);
        if (!this.success) {
            sb.append(", logs=[");
            for (int i = 0; i < this.logs.size(); ++i) {
                sb.append(this.logs.get(i).toString());
                if (i == this.logs.size() - 1) continue;
                sb.append("; ");
            }
            sb.append("]");
        } else {
            sb.append(", req=");
            sb.append(this.req);
        }
        return sb.toString();
    }
}

