/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.transactions.TransactionGetResult;
import com.couchbase.transactions.util.LogDeferDocId;
import com.couchbase.transactions.util.LogDeferThrowable;
import java.util.function.Consumer;

@Stability.Internal
public class DebugUtil {
    private DebugUtil() {
    }

    public static LogDeferThrowable dbg(Throwable err) {
        if (err == null) {
            return null;
        }
        return new LogDeferThrowable(err);
    }

    public static LogDeferDocId docId(ReactiveCollection collection, String docId) {
        return new LogDeferDocId(collection, docId);
    }

    public static LogDeferDocId docId(TransactionGetResult doc) {
        return DebugUtil.docId(doc.collection(), doc.id());
    }

    public static void fetchElidedStacktrace(Throwable err, Consumer<String> onEach) {
        StackTraceElement[] st;
        for (StackTraceElement s : st = err.getStackTrace()) {
            String str = s.toString();
            if (str.startsWith("reactor.") || str.startsWith("java.") || str.startsWith("com.couchbase.client.core")) continue;
            onEach.accept(str);
        }
    }
}

