/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.transactions.util.DebugUtil;

@Stability.Internal
public class LogDeferThrowable {
    private final Throwable err;

    public LogDeferThrowable(Throwable err) {
        this.err = err;
    }

    public String toString() {
        StringBuilder out = new StringBuilder(RedactableArgument.redactUser((Object)this.err.toString()).toString());
        if (this.err.getCause() == null) {
            out.append(" no cause");
        } else {
            out.append(" cause: ");
            out.append(RedactableArgument.redactUser((Object)this.err.getCause().toString()));
        }
        out.append(" stacktrace:\n");
        DebugUtil.fetchElidedStacktrace(this.err, s -> {
            out.append("          ");
            out.append((String)s);
            out.append('\n');
        });
        return out.toString();
    }
}

