/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.components;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.transactions.components.ATREntry;
import com.couchbase.transactions.components.CasMode;
import java.util.List;
import java.util.Objects;

@Stability.Internal
public class ATR {
    private final List<ATREntry> entries;
    private final String id;
    private final ReactiveCollection collection;
    private final long casInNanos;
    private final CasMode casMode;

    public ATR(String id, ReactiveCollection collection, long casInNanos, List<ATREntry> entries, CasMode casMode) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(collection);
        Objects.requireNonNull(entries);
        this.entries = entries;
        this.id = id;
        this.collection = collection;
        this.casInNanos = casInNanos;
        this.casMode = casMode;
    }

    public ReactiveCollection collection() {
        return this.collection;
    }

    public String bucketName() {
        return this.collection.bucketName();
    }

    public List<ATREntry> entries() {
        return this.entries;
    }

    public String id() {
        return this.id;
    }

    public long cas() {
        return this.casInNanos;
    }

    public long casInMillis() {
        return this.casInNanos / 1000000L;
    }

    public CasMode casMode() {
        return this.casMode;
    }
}

