/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.forwards;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.transactions.forwards.ForwardCompatBehaviourFull;
import com.couchbase.transactions.forwards.ForwardCompatRequirement;
import com.couchbase.transactions.forwards.Supported;

@Stability.Internal
class ForwardCompatProtocolRequirement
extends ForwardCompatRequirement {
    public final int minProtocolMajor;
    public final int minProtocolMinor;

    ForwardCompatProtocolRequirement(JsonObject json) {
        super(json);
        String protocolVersion = json.getString("p");
        String[] split = protocolVersion.split("\\.");
        this.minProtocolMajor = Integer.parseInt(split[0]);
        this.minProtocolMinor = Integer.parseInt(split[1]);
    }

    @Override
    public ForwardCompatBehaviourFull behaviour(Supported supported) {
        if (supported.protocolMajor > this.minProtocolMajor) {
            return ForwardCompatBehaviourFull.CONTINUE;
        }
        if (supported.protocolMajor < this.minProtocolMajor) {
            return this.behaviour;
        }
        if (supported.protocolMinor < this.minProtocolMinor) {
            return this.behaviour;
        }
        return ForwardCompatBehaviourFull.CONTINUE;
    }
}

