/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.forwards;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.transactions.forwards.ForwardCompatBehaviour;
import com.couchbase.transactions.forwards.ForwardCompatBehaviourFull;
import com.couchbase.transactions.forwards.ForwardCompatExtensionRequirement;
import com.couchbase.transactions.forwards.ForwardCompatProtocolRequirement;
import com.couchbase.transactions.forwards.ForwardCompatRequirement;
import com.couchbase.transactions.forwards.Supported;
import java.util.ArrayList;
import java.util.List;

@Stability.Internal
class ForwardCompatibilityForStage {
    private final List<ForwardCompatRequirement> bases = new ArrayList<ForwardCompatRequirement>();

    ForwardCompatibilityForStage(JsonArray a) {
        int count = a.size();
        for (int i = 0; i < count; ++i) {
            JsonObject o = a.getObject(i);
            if (o.containsKey("e") && o.containsKey("b")) {
                this.bases.add(new ForwardCompatExtensionRequirement(o));
                continue;
            }
            if (!o.containsKey("p") || !o.containsKey("b")) continue;
            this.bases.add(new ForwardCompatProtocolRequirement(o));
        }
    }

    public ForwardCompatBehaviourFull behaviour(Supported supported) {
        for (ForwardCompatRequirement b : this.bases) {
            ForwardCompatBehaviourFull be = b.behaviour(supported);
            if (be.behaviour == ForwardCompatBehaviour.CONTINUE) continue;
            return be;
        }
        return ForwardCompatBehaviourFull.CONTINUE;
    }
}

