/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.transactions.util.Node;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

@Stability.Internal
public class ConcurrentDoublyLinkedList<E>
extends AbstractCollection<E>
implements Serializable {
    private static final long serialVersionUID = 876323262645176354L;
    private final Node<E> header;
    private final Node<E> trailer;

    private static boolean usable(Node<?> n) {
        return n != null && !n.isSpecial();
    }

    private static void checkNullArg(Object v) {
        if (v == null) {
            throw new NullPointerException();
        }
    }

    private E screenNullResult(E v) {
        if (v == null) {
            throw new NoSuchElementException();
        }
        return v;
    }

    private ArrayList<E> toArrayList() {
        ArrayList c = new ArrayList();
        for (Node<E> n = this.header.forward(); n != null; n = n.forward()) {
            c.add(n.element);
        }
        return c;
    }

    public ConcurrentDoublyLinkedList() {
        Node<Object> h = new Node<Object>(null, null, null);
        Node<Object> t = new Node<Object>(null, null, h);
        h.setNext(t);
        this.header = h;
        this.trailer = t;
    }

    public ConcurrentDoublyLinkedList(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    public void addFirst(E o) {
        ConcurrentDoublyLinkedList.checkNullArg(o);
        while (this.header.append(o) == null) {
        }
    }

    public void addLast(E o) {
        ConcurrentDoublyLinkedList.checkNullArg(o);
        while (this.trailer.prepend(o) == null) {
        }
    }

    public boolean offerFirst(E o) {
        this.addFirst(o);
        return true;
    }

    public boolean offerLast(E o) {
        this.addLast(o);
        return true;
    }

    public E peekFirst() {
        Node<E> n = this.header.successor();
        return n == null ? null : (E)n.element;
    }

    public E peekLast() {
        Node<E> n = this.trailer.predecessor();
        return n == null ? null : (E)n.element;
    }

    public E getFirst() {
        return this.screenNullResult(this.peekFirst());
    }

    public E getLast() {
        return this.screenNullResult(this.peekLast());
    }

    public E pollFirst() {
        Node<E> n;
        do {
            if (ConcurrentDoublyLinkedList.usable(n = this.header.successor())) continue;
            return null;
        } while (!n.delete());
        return n.element;
    }

    public E pollLast() {
        Node<E> n;
        do {
            if (ConcurrentDoublyLinkedList.usable(n = this.trailer.predecessor())) continue;
            return null;
        } while (!n.delete());
        return n.element;
    }

    public E removeFirst() {
        return this.screenNullResult(this.pollFirst());
    }

    public E removeLast() {
        return this.screenNullResult(this.pollLast());
    }

    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public boolean add(E e) {
        return this.offerLast(e);
    }

    public E poll() {
        return this.pollFirst();
    }

    public E remove() {
        return this.removeFirst();
    }

    public E peek() {
        return this.peekFirst();
    }

    public E element() {
        return this.getFirst();
    }

    public void push(E e) {
        this.addFirst(e);
    }

    public E pop() {
        return this.removeFirst();
    }

    public boolean removeFirstOccurrence(Object o) {
        ConcurrentDoublyLinkedList.checkNullArg(o);
        block0: while (true) {
            Node<E> n = this.header.forward();
            while (true) {
                if (n == null) {
                    return false;
                }
                if (o.equals(n.element)) {
                    if (!n.delete()) continue block0;
                    return true;
                }
                n = n.forward();
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean removeLastOccurrence(Object o) {
        ConcurrentDoublyLinkedList.checkNullArg(o);
        block0: while (true) {
            Node<E> s = this.trailer;
            while (true) {
                Node<E> n = s.back();
                if (s.isDeleted() || n != null && n.successor() != s) continue block0;
                if (n == null) {
                    return false;
                }
                if (o.equals(n.element)) {
                    if (n.delete()) return true;
                    continue block0;
                }
                s = n;
            }
            break;
        }
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        for (Node<E> n = this.header.forward(); n != null; n = n.forward()) {
            if (!o.equals(n.element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return !ConcurrentDoublyLinkedList.usable(this.header.successor());
    }

    @Override
    public int size() {
        long count = 0L;
        for (Node<E> n = this.header.forward(); n != null; n = n.forward()) {
            ++count;
        }
        return count >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
    }

    @Override
    public boolean remove(Object o) {
        return this.removeFirstOccurrence(o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Iterator<E> it = c.iterator();
        if (!it.hasNext()) {
            return false;
        }
        do {
            this.addLast(it.next());
        } while (it.hasNext());
        return true;
    }

    @Override
    public void clear() {
        while (this.pollFirst() != null) {
        }
    }

    @Override
    public Object[] toArray() {
        return this.toArrayList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toArrayList().toArray(a);
    }

    @Override
    public Iterator<E> iterator() {
        return new CLDIterator();
    }

    final class CLDIterator
    implements Iterator<E> {
        Node<E> last;
        Node<E> next;

        CLDIterator() {
            this.next = ConcurrentDoublyLinkedList.this.header.forward();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            this.last = this.next;
            Node l = this.last;
            if (l == null) {
                throw new NoSuchElementException();
            }
            this.next = this.next.forward();
            return l.element;
        }

        @Override
        public void remove() {
            Node l = this.last;
            if (l == null) {
                throw new IllegalStateException();
            }
            while (!l.delete() && !l.isDeleted()) {
            }
        }
    }
}

