/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.util;

import java.util.concurrent.atomic.AtomicReference;

class Node<E>
extends AtomicReference<Node<E>> {
    private volatile Node<E> prev;
    final E element;

    Node(E element, Node<E> next, Node<E> prev) {
        super(next);
        this.prev = prev;
        this.element = element;
    }

    Node(Node<E> next) {
        super(next);
        this.prev = this;
        this.element = null;
    }

    private Node<E> getNext() {
        return (Node)this.get();
    }

    void setNext(Node<E> n) {
        this.set(n);
    }

    private boolean casNext(Node<E> cmp, Node<E> val) {
        return this.compareAndSet(cmp, val);
    }

    private Node<E> getPrev() {
        return this.prev;
    }

    void setPrev(Node<E> b) {
        this.prev = b;
    }

    boolean isSpecial() {
        return this.element == null;
    }

    boolean isTrailer() {
        return this.getNext() == null;
    }

    boolean isHeader() {
        return this.getPrev() == null;
    }

    boolean isMarker() {
        return this.getPrev() == this;
    }

    boolean isDeleted() {
        Node<E> f = this.getNext();
        return f != null && f.isMarker();
    }

    private Node<E> nextNonmarker() {
        Node<E> f = this.getNext();
        return f == null || !f.isMarker() ? f : super.getNext();
    }

    Node<E> successor() {
        Node<E> f = this.nextNonmarker();
        while (f != null) {
            if (!f.isDeleted()) {
                if (super.getPrev() != this && !this.isDeleted()) {
                    f.setPrev(this);
                }
                return f;
            }
            Node<E> s = super.nextNonmarker();
            if (f == this.getNext()) {
                this.casNext(f, s);
            }
            f = s;
        }
        return null;
    }

    private Node<E> findPredecessorOf(Node<E> target) {
        Node<E> n = this;
        Node<E> f;
        while ((f = n.successor()) != target) {
            if (f == null) {
                return null;
            }
            n = f;
        }
        return n;
    }

    Node<E> predecessor() {
        Node<E> n = this;
        Node<E> b;
        while ((b = n.getPrev()) != null) {
            Node<E> p;
            Node<E> s = super.getNext();
            if (s == this) {
                return b;
            }
            if (!(s != null && s.isMarker() || (p = super.findPredecessorOf(this)) == null)) {
                return p;
            }
            n = b;
        }
        return n.findPredecessorOf(this);
    }

    Node<E> forward() {
        Node<E> f = this.successor();
        return f == null || f.isSpecial() ? null : f;
    }

    Node<E> back() {
        Node<E> f = this.predecessor();
        return f == null || f.isSpecial() ? null : f;
    }

    Node<E> append(E element) {
        Node<E> x;
        Node<E> f;
        do {
            if ((f = this.getNext()) != null && !f.isMarker()) continue;
            return null;
        } while (!this.casNext(f, x = new Node<E>(element, f, this)));
        f.setPrev(x);
        return x;
    }

    Node<E> prepend(E element) {
        Node<E> x;
        Node<E> b;
        do {
            if ((b = this.predecessor()) != null) continue;
            return null;
        } while (!super.casNext(this, x = new Node<E>(element, this, b)));
        this.setPrev(x);
        return x;
    }

    boolean delete() {
        Node<E> b = this.getPrev();
        Node<E> f = this.getNext();
        if (b != null && f != null && !f.isMarker() && this.casNext(f, new Node<E>(f))) {
            if (super.casNext(this, f)) {
                f.setPrev(b);
            }
            return true;
        }
        return false;
    }

    Node<E> replace(E newElement) {
        Node<E> b;
        Node<E> x;
        Node<E> f;
        do {
            b = this.getPrev();
            f = this.getNext();
            if (b != null && f != null && !f.isMarker()) continue;
            return null;
        } while (!this.casNext(f, new Node<E>(x = new Node<E>(newElement, f, b))));
        b.successor();
        x.successor();
        return x;
    }
}

