/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.msg.query.QueryResponse;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.query.ReactiveQueryResult;
import com.couchbase.transactions.log.TransactionLogger;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Stability.Internal
public class SDKAccessUtil {
    private SDKAccessUtil() {
    }

    public static ReactiveQueryResult createReactiveQueryResult(TransactionLogger logger, ReactiveQueryResult qr, Consumer<Throwable> errorHandler, JsonSerializer serializer) {
        try {
            Field queryResponseField = ReactiveQueryResult.class.getDeclaredField("response");
            queryResponseField.setAccessible(true);
            QueryResponse orig = (QueryResponse)queryResponseField.get(qr);
            Flux rows = orig.rows().onErrorResume(err -> {
                errorHandler.accept((Throwable)err);
                return Mono.empty();
            });
            QueryResponse wrapped = new QueryResponse(orig.status(), orig.header(), rows, orig.trailer());
            return com.couchbase.client.java.query.SDKAccessUtil.createReactiveQueryResult(wrapped, serializer);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.error("", "Got error " + e);
            throw new RuntimeException(e);
        }
    }
}

