/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.LookupInResult;
import com.couchbase.transactions.TransactionJsonDocumentStatus;
import com.couchbase.transactions.cleanup.ClusterData;
import com.couchbase.transactions.components.DocumentMetadata;
import com.couchbase.transactions.components.TransactionLinks;
import com.couchbase.transactions.forwards.ForwardCompatibility;
import com.couchbase.transactions.util.DebugUtil;
import java.util.Optional;
import reactor.util.annotation.Nullable;

public class TransactionGetResult {
    @Nullable
    private final TransactionLinks links;
    private final Optional<DocumentMetadata> documentMetadata;
    private final Optional<String> crc32OfGet;
    private TransactionJsonDocumentStatus status;
    private byte[] content;
    private long cas;
    private final String id;
    private final ReactiveCollection collection;
    private final Transcoder transcoder;
    private final Optional<JsonObject> txnMeta;

    @Stability.Internal
    public TransactionGetResult(String id, @Nullable byte[] content, long cas, ReactiveCollection collection, @Nullable TransactionLinks links, TransactionJsonDocumentStatus status, Optional<DocumentMetadata> documentMetadata, Transcoder transcoder, Optional<JsonObject> txnMeta, Optional<String> crc32OfGet) {
        this.id = id;
        this.content = content;
        this.cas = cas;
        this.collection = collection;
        this.links = links;
        this.status = status;
        this.documentMetadata = documentMetadata;
        this.transcoder = transcoder;
        this.txnMeta = txnMeta;
        this.crc32OfGet = crc32OfGet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TransactionGetResult{");
        sb.append("id=").append(DebugUtil.docId(this.collection, this.id));
        sb.append(",cas=").append(this.cas);
        sb.append(",status=").append((Object)this.status);
        sb.append(",bucket=").append(this.collection.bucketName());
        sb.append(",coll=").append(this.collection.name());
        sb.append(",links=").append(this.links);
        sb.append(",txnMeta=").append(this.txnMeta);
        sb.append('}');
        return sb.toString();
    }

    @Stability.Internal
    public Optional<DocumentMetadata> documentMetadata() {
        return this.documentMetadata;
    }

    @Stability.Internal
    @Nullable
    public TransactionLinks links() {
        return this.links;
    }

    @Stability.Internal
    Optional<JsonObject> txnMeta() {
        return this.txnMeta;
    }

    public String id() {
        return this.id;
    }

    public long cas() {
        return this.cas;
    }

    public JsonObject contentAsObject() {
        return this.contentAs(JsonObject.class);
    }

    public <T> T contentAs(Class<T> target) {
        return (T)this.transcoder.decode(target, this.content, CodecFlags.JSON_COMPAT_FLAGS);
    }

    @Stability.Uncommitted
    public <T> T contentAs(Class<T> target, JsonSerializer serializer) {
        return (T)serializer.deserialize(target, this.content);
    }

    @Stability.Uncommitted
    public byte[] contentAsBytes() {
        return this.content;
    }

    TransactionGetResult cas(long cas) {
        this.cas = cas;
        return this;
    }

    @Deprecated
    @Nullable
    public TransactionJsonDocumentStatus status() {
        return this.status;
    }

    @Stability.Internal
    void serialize(JsonObject out) {
        out.put("cas", this.cas);
        out.put("id", this.id);
        out.put("collection", this.collection.name());
        out.put("bucket", this.collection.bucketName());
        out.put("scope", this.collection.scopeName());
    }

    @Stability.Internal
    Optional<String> crc32OfGet() {
        return this.crc32OfGet;
    }

    @Stability.Internal
    static TransactionGetResult createFrom(JsonObject obj, ClusterData cd) {
        TransactionGetResult out = new TransactionGetResult(obj.getString("id"), new byte[0], obj.getLong("cas"), cd.getBucketFromName(obj.getString("bucket")).scope(obj.getString("scope")).collection(obj.getString("collection")), null, TransactionJsonDocumentStatus.NORMAL, Optional.empty(), cd.cluster().environment().transcoder(), Optional.empty(), Optional.empty());
        return out;
    }

    @Stability.Internal
    public TransactionGetResult status(TransactionJsonDocumentStatus status) {
        this.status = status;
        return this;
    }

    @Stability.Internal
    static TransactionGetResult createFromInsert(ReactiveCollection collection, String id, byte[] content, String transactionId, String attemptId, String atrId, String atrBucketName, String atrScopeName, String atrCollectionName, long cas, Transcoder transcoder) {
        TransactionLinks links = new TransactionLinks(Optional.of(new String(content, CharsetUtil.UTF_8)), Optional.ofNullable(atrId), Optional.ofNullable(atrBucketName), Optional.ofNullable(atrScopeName), Optional.ofNullable(atrCollectionName), Optional.of(transactionId), Optional.of(attemptId), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of("insert"), true, Optional.empty(), Optional.empty(), Optional.empty());
        TransactionGetResult out = new TransactionGetResult(id, content, cas, collection, links, TransactionJsonDocumentStatus.NORMAL, Optional.empty(), transcoder, Optional.empty(), Optional.empty());
        return out;
    }

    @Stability.Internal
    public static TransactionGetResult createFrom(TransactionGetResult doc, byte[] content, TransactionJsonDocumentStatus status) {
        TransactionLinks links = new TransactionLinks(doc.links.stagedContent(), doc.links.atrId(), doc.links.atrBucketName(), doc.links.atrScopeName(), doc.links.atrCollectionName(), doc.links.stagedTransactionId(), doc.links.stagedAttemptId(), doc.links.casPreTxn(), doc.links.revidPreTxn(), doc.links.exptimePreTxn(), doc.links.op(), doc.links.isDeleted(), doc.links.crc32OfStaging(), doc.links.forwardCompatibility(), doc.links.stagedOperationId());
        TransactionGetResult out = new TransactionGetResult(doc.id, content, doc.cas, doc.collection, links, status, doc.documentMetadata, doc.transcoder, Optional.empty(), doc.crc32OfGet);
        return out;
    }

    @Stability.Internal
    public static TransactionGetResult createFrom(ReactiveCollection collection, String documentId, LookupInResult doc, TransactionJsonDocumentStatus status, Transcoder transcoder) {
        JsonObject restore;
        Optional<String> atrId = Optional.empty();
        Optional<String> transactionId = Optional.empty();
        Optional<String> attemptId = Optional.empty();
        Optional<String> operationId = Optional.empty();
        Optional<String> stagedContent = Optional.empty();
        Optional<String> atrBucketName = Optional.empty();
        Optional<String> atrScopeName = Optional.empty();
        Optional<String> atrCollectionName = Optional.empty();
        Optional<String> crc32OfStaging = Optional.empty();
        Optional<ForwardCompatibility> forwardCompatibility = Optional.empty();
        Optional<String> casPreTxn = Optional.empty();
        Optional<String> revidPreTxn = Optional.empty();
        Optional<Long> exptimePreTxn = Optional.empty();
        Optional<String> op = Optional.empty();
        if (doc.exists(0)) {
            JsonObject id = doc.contentAsObject(0);
            transactionId = Optional.ofNullable(id.getString("txn"));
            attemptId = Optional.ofNullable(id.getString("atmpt"));
            operationId = Optional.ofNullable(id.getString("op"));
        }
        if (doc.exists(1)) {
            JsonObject atr = doc.contentAsObject(1);
            atrId = Optional.ofNullable(atr.getString("id"));
            atrBucketName = Optional.ofNullable(atr.getString("bkt"));
            String scope = atr.getString("scp");
            String coll = atr.getString("coll");
            if (scope != null) {
                atrScopeName = Optional.ofNullable(scope);
                atrCollectionName = Optional.ofNullable(coll);
            } else {
                String[] splits = coll.split("\\.");
                atrScopeName = Optional.of(splits[0]);
                atrCollectionName = Optional.of(splits[1]);
            }
        }
        if (doc.exists(2)) {
            op = Optional.ofNullable((String)doc.contentAs(2, String.class));
        }
        if (doc.exists(3)) {
            byte[] raw = (byte[])doc.contentAs(3, byte[].class);
            String str = new String(raw, CharsetUtil.UTF_8);
            stagedContent = Optional.of(str);
        }
        if (doc.exists(4)) {
            crc32OfStaging = Optional.of((String)doc.contentAs(4, String.class));
        }
        if (doc.exists(5)) {
            restore = (JsonObject)doc.contentAs(5, JsonObject.class);
            casPreTxn = Optional.of(restore.getString("CAS"));
            revidPreTxn = Optional.of(restore.getString("revid"));
            exptimePreTxn = Optional.of(restore.getLong("exptime"));
        }
        if (doc.exists(6)) {
            JsonObject json = doc.contentAsObject(6);
            ForwardCompatibility fc = new ForwardCompatibility(json);
            forwardCompatibility = Optional.of(fc);
        }
        if (!doc.exists(7)) {
            throw new IllegalStateException("$document requested but not received");
        }
        restore = (JsonObject)doc.contentAs(7, JsonObject.class);
        String casFromDocument = restore.getString("CAS");
        String revidFromDocument = restore.getString("revid");
        Long exptimeFromDocument = restore.getLong("exptime");
        String crc32FromDocument = restore.getString("value_crc32c");
        byte[] content = doc.exists(8) ? (byte[])doc.contentAs(8, byte[].class) : new byte[]{};
        TransactionLinks links = new TransactionLinks(stagedContent, atrId, atrBucketName, atrScopeName, atrCollectionName, transactionId, attemptId, casPreTxn, revidPreTxn, exptimePreTxn, op, doc.isDeleted(), crc32OfStaging, forwardCompatibility, operationId);
        DocumentMetadata md = new DocumentMetadata(casFromDocument, revidFromDocument, exptimeFromDocument);
        TransactionGetResult out = new TransactionGetResult(documentId, content, doc.cas(), collection, links, status, Optional.of(md), transcoder, Optional.empty(), Optional.of(crc32FromDocument));
        return out;
    }

    public ReactiveCollection collection() {
        return this.collection;
    }
}

