/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.atr;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.transactions.atr.ATRIds;
import com.couchbase.transactions.atr.MarkableCrc32;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.zip.CRC32;

@Stability.Internal
public class GenerateATRIds {
    private GenerateATRIds() {
    }

    public static void main(String[] args) {
        int NUM_PARTITIONS = 1024;
        int NUM_ITERATIONS = 20;
        HashSet<String> existing = new HashSet<String>(ATRIds.allAtrs(1000000));
        GenerateATRIds.sanityTest("randomKey");
        for (int j = 0; j < NUM_ITERATIONS; ++j) {
            System.out.println("// Block " + (j + 1) + " of " + NUM_ITERATIONS);
            for (int i = 0; i < NUM_PARTITIONS; ++i) {
                Optional<String> atrIdOpt = GenerateATRIds.forceKeyToPartition("_txn:atr-" + i + "-", i, NUM_PARTITIONS, existing);
                if (atrIdOpt.isPresent()) {
                    existing.add(atrIdOpt.get());
                    if (GenerateATRIds.partitionForKey(atrIdOpt.get().getBytes(StandardCharsets.UTF_8), 1024) != i) {
                        throw new IllegalStateException("Hashed to wrong partition");
                    }
                } else {
                    throw new IllegalStateException("Could not create ATR id");
                }
                System.out.println("\"" + atrIdOpt.get() + "\",");
            }
        }
    }

    public static Optional<String> forceKeyToPartition(String key, int desiredPartition, int numPartitions, Set<String> existing) {
        if (desiredPartition >= numPartitions) {
            throw new IllegalArgumentException();
        }
        if (numPartitions <= 0) {
            throw new IllegalArgumentException();
        }
        if (desiredPartition < 0) {
            throw new IllegalArgumentException();
        }
        int MAX_ITERATIONS = 10000000;
        Charset utf8 = StandardCharsets.UTF_8;
        MarkableCrc32 crc32 = new MarkableCrc32();
        byte[] keyBytes = (key + "#").getBytes(utf8);
        crc32.update(keyBytes, 0, keyBytes.length);
        crc32.mark();
        for (long salt = 0L; salt < 10000000L; ++salt) {
            String possible;
            crc32.reset();
            String saltString = Long.toHexString(salt);
            int max = saltString.length();
            for (int i = 0; i < max; ++i) {
                crc32.update(saltString.charAt(i));
            }
            long rv = crc32.getValue() >> 16 & 0x7FFFL;
            int actualPartition = (int)rv & numPartitions - 1;
            if (actualPartition != desiredPartition || existing.contains(possible = new String(keyBytes, utf8) + saltString)) continue;
            return Optional.of(possible);
        }
        System.err.println(String.format("Failed to force partition for %s after %d iterations.", key, 10000000));
        return Optional.empty();
    }

    private static int partitionForKey(byte[] id, int numPartitions) {
        CRC32 crc32 = new CRC32();
        crc32.update(id, 0, id.length);
        long rv = crc32.getValue() >> 16 & 0x7FFFL;
        return (int)rv & numPartitions - 1;
    }

    private static void sanityTest(String someKey) {
        String atrId;
        int partitionForAtr;
        int numPartitions = 1024;
        int partition = GenerateATRIds.partitionForKey(someKey.getBytes(StandardCharsets.UTF_8), numPartitions);
        if (partition != (partitionForAtr = GenerateATRIds.partitionForKey((atrId = GenerateATRIds.forceKeyToPartition("_txn:atr-" + partition + "-", partition, numPartitions, new HashSet<String>()).get()).getBytes(StandardCharsets.UTF_8), numPartitions))) {
            throw new IllegalStateException("Partition ids don't match");
        }
    }
}

