/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.components;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.logging.RedactableArgument;
import java.util.HashMap;
import java.util.Objects;

@Stability.Internal
public class DocRecord {
    private final String bucketName;
    private final String scopeName;
    private final String collectionName;
    private final String id;

    public DocRecord(String bucketName, String scopeName, String collectionName, String id) {
        Objects.requireNonNull(bucketName);
        Objects.requireNonNull(collectionName);
        Objects.requireNonNull(bucketName);
        Objects.requireNonNull(id);
        this.bucketName = bucketName;
        this.scopeName = scopeName;
        this.collectionName = collectionName;
        this.id = id;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String scopeName() {
        return this.scopeName;
    }

    public String collectionName() {
        return this.collectionName;
    }

    public String id() {
        return this.id;
    }

    public static DocRecord createFrom(HashMap o) {
        return new DocRecord((String)o.get("bkt"), (String)o.get("scp"), (String)o.get("col"), (String)o.get("id"));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(RedactableArgument.redactUser((Object)this.bucketName));
        if (!this.scopeName.equals("_default")) {
            sb.append('.');
            sb.append(RedactableArgument.redactUser((Object)this.scopeName));
        }
        if (!this.collectionName.equals("_default")) {
            sb.append('.');
            sb.append(RedactableArgument.redactUser((Object)this.collectionName));
        }
        sb.append('.');
        sb.append(RedactableArgument.redactUser((Object)this.id));
        return sb.toString();
    }
}

