/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.components;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.kv.LookupInOptions;
import com.couchbase.client.java.kv.LookupInResult;
import com.couchbase.client.java.kv.LookupInSpec;
import com.couchbase.transactions.TransactionGetResult;
import com.couchbase.transactions.TransactionJsonDocumentStatus;
import com.couchbase.transactions.components.ATREntry;
import com.couchbase.transactions.components.ATRUtil;
import com.couchbase.transactions.components.ActiveTransactionRecord;
import com.couchbase.transactions.components.SerializationUtil;
import com.couchbase.transactions.config.MergedTransactionConfig;
import com.couchbase.transactions.error.attempts.ActiveTransactionRecordEntryNotFound;
import com.couchbase.transactions.error.attempts.ActiveTransactionRecordNotFound;
import com.couchbase.transactions.error.internal.ErrorClasses;
import com.couchbase.transactions.forwards.ForwardCompatibility;
import com.couchbase.transactions.forwards.ForwardCompatibilityStages;
import com.couchbase.transactions.forwards.Supported;
import com.couchbase.transactions.log.TransactionLogger;
import com.couchbase.transactions.support.OptionsWrapperUtil;
import com.couchbase.transactions.support.SpanWrapper;
import com.couchbase.transactions.util.DebugUtil;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@Stability.Internal
public class DocumentGetter {
    private DocumentGetter() {
    }

    public static Mono<Optional<TransactionGetResult>> getAsync(Cluster cluster, ReactiveCollection collection, MergedTransactionConfig config, String docId, String byAttemptId, @Nullable SpanWrapper span, Transcoder transcoder) {
        return DocumentGetter.getAsync(cluster, null, collection, config, docId, byAttemptId, false, span, transcoder, Optional.empty());
    }

    public static Mono<Optional<TransactionGetResult>> getAsync(Cluster cluster, TransactionLogger LOGGER, ReactiveCollection collection, MergedTransactionConfig config, String docId, String byAttemptId, boolean justReturn, @Nullable SpanWrapper span, Transcoder transcoder, Optional<String> resolvingMissingATREntry) {
        return DocumentGetter.justGetDoc(collection, config, docId, span, transcoder, true, LOGGER).flatMap(origTrans -> {
            if (justReturn) {
                return Mono.just(origTrans.map(v -> (TransactionGetResult)v.getT1()));
            }
            if (origTrans.isPresent()) {
                TransactionGetResult r = (TransactionGetResult)((Tuple2)origTrans.get()).getT1();
                LookupInResult lir = (LookupInResult)((Tuple2)origTrans.get()).getT2();
                if (!r.links().isDocumentInTransaction()) {
                    if (lir.isDeleted()) {
                        return Mono.just(Optional.empty());
                    }
                    return Mono.just(Optional.of(r));
                }
                if (resolvingMissingATREntry.equals(r.links().stagedAttemptId())) {
                    if (r.links().op().isPresent() && r.links().op().get().equals("insert")) {
                        if (LOGGER != null) {
                            LOGGER.info(byAttemptId, "doc %s is in the same transaction as last time indicating it's part of a lost PENDING transaction, it's a staged insert so returning empty", DebugUtil.docId(collection, docId));
                        }
                        return Mono.just(Optional.empty());
                    }
                    if (LOGGER != null) {
                        LOGGER.info(byAttemptId, "doc %s is in the same transaction as last time indicating it's part of a lost PENDING transaction, returning body", DebugUtil.docId(collection, docId));
                    }
                    r.status(TransactionJsonDocumentStatus.IN_TXN_OTHER);
                    return Mono.just(Optional.of(r));
                }
                ReactiveCollection atrCollection = cluster.reactive().bucket(r.links().atrBucketName().get()).scope(r.links().atrScopeName().get()).collection(r.links().atrCollectionName().get());
                if (LOGGER != null) {
                    LOGGER.info(byAttemptId, "doc %s is in a transaction %s, looking up its status from ATR %s (MAV read)", DebugUtil.docId(collection, docId), r.links().stagedAttemptId(), ATRUtil.getAtrDebug(atrCollection, r.links().atrId()));
                }
                return DocumentGetter.lookupStatusFromATR(atrCollection, r, byAttemptId, config, span, LOGGER);
            }
            if (LOGGER != null) {
                LOGGER.info(byAttemptId, "doc %s is not in a transaction", DebugUtil.docId(collection, docId));
            }
            return Mono.just(origTrans.map(v -> (TransactionGetResult)v.getT1()));
        });
    }

    public static Mono<Optional<TransactionGetResult>> justGetDoc(ReactiveCollection collection, MergedTransactionConfig config, String docId, SpanWrapper span, Transcoder transcoder) {
        return DocumentGetter.justGetDoc(collection, config, docId, span, transcoder, false, null).map(v -> v.map(x -> (TransactionGetResult)x.getT1()));
    }

    public static Mono<Optional<Tuple2<TransactionGetResult, LookupInResult>>> justGetDoc(ReactiveCollection collection, MergedTransactionConfig config, String docId, @Nullable SpanWrapper span, Transcoder transcoder, boolean accessDeleted, @Nullable TransactionLogger logger) {
        return collection.lookupIn(docId, Arrays.asList(LookupInSpec.get((String)"txn.id").xattr(), LookupInSpec.get((String)"txn.atr").xattr(), LookupInSpec.get((String)"txn.op.type").xattr(), LookupInSpec.get((String)"txn.op.stgd").xattr(), LookupInSpec.get((String)"txn.op.crc32").xattr(), LookupInSpec.get((String)"txn.restore").xattr(), LookupInSpec.get((String)"txn.fc").xattr(), LookupInSpec.get((String)"$document").xattr(), LookupInSpec.get((String)"")), (LookupInOptions)((LookupInOptions)((LookupInOptions)LookupInOptions.lookupInOptions().serializer((JsonSerializer)SerializationUtil.DEFAULT_JSON_SERIALIZER).accessDeleted(accessDeleted).parentSpan(span == null ? null : span.span())).clientContext(OptionsWrapperUtil.createClientContext("DocumentGetter::justGetDoc"))).timeout(OptionsWrapperUtil.kvTimeoutNonMutating(config, collection.core()))).map(fragment -> {
            try {
                return Optional.of(Tuples.of((Object)TransactionGetResult.createFrom(collection, docId, fragment, TransactionJsonDocumentStatus.NORMAL, transcoder), (Object)fragment));
            }
            catch (Throwable err) {
                if (logger != null) {
                    logger.info("", String.format("Hit error while decoding doc's transaction metadata %s.%s.%s.%s %s", collection.bucketName(), collection.scopeName(), collection.name(), docId, DebugUtil.dbg(err)));
                    for (int i = 0; i < 10; ++i) {
                        DocumentGetter.dumpRawLookupInField(logger, fragment, 0);
                    }
                }
                throw err;
            }
        }).onErrorResume(err -> {
            ErrorClasses ec = ErrorClasses.classify(err);
            if (ec == ErrorClasses.FAIL_DOC_NOT_FOUND) {
                return Mono.just(Optional.empty());
            }
            return Mono.error((Throwable)err);
        });
    }

    private static void dumpRawLookupInField(TransactionLogger logger, LookupInResult fragment, int index) {
        try {
            if (fragment.exists(index)) {
                byte[] raw = (byte[])fragment.contentAs(index, byte[].class);
                String asStr = new String(raw, StandardCharsets.UTF_8);
                logger.info("", "Field %d: %s", index, asStr);
            } else {
                logger.info("", "Field %d not found", index);
            }
        }
        catch (Throwable err) {
            logger.info("", "Error on field %d: %s", index, DebugUtil.dbg(err));
        }
    }

    private static Mono<Optional<TransactionGetResult>> lookupStatusFromATR(ReactiveCollection collection, TransactionGetResult doc, String byAttemptId, MergedTransactionConfig config, SpanWrapper span, TransactionLogger logger) {
        assert (doc.links().isDocumentInTransaction());
        assert (doc.links().atrId().isPresent());
        assert (doc.links().stagedAttemptId().isPresent());
        String atrId = doc.links().atrId().get();
        String attemptIdOfDoc = doc.links().stagedAttemptId().get();
        return ActiveTransactionRecord.findEntryForTransaction(collection, atrId, attemptIdOfDoc, config, span, logger).onErrorResume(err -> {
            ErrorClasses ec = ErrorClasses.classify(err);
            if (ec == ErrorClasses.FAIL_DOC_NOT_FOUND) {
                return Mono.error((Throwable)new ActiveTransactionRecordNotFound(atrId, attemptIdOfDoc));
            }
            return Mono.error((Throwable)err);
        }).flatMap(atrDocOpt -> {
            if (!atrDocOpt.isPresent()) {
                return Mono.error((Throwable)new ActiveTransactionRecordEntryNotFound(atrId, attemptIdOfDoc));
            }
            return DocumentGetter.atrFound(doc, byAttemptId, (ATREntry)atrDocOpt.get(), logger);
        });
    }

    private static Mono<Optional<TransactionGetResult>> atrFound(TransactionGetResult doc, String byAttemptId, ATREntry entry, TransactionLogger logger) {
        if (doc.links().stagedAttemptId().isPresent() && entry.attemptId().equals(byAttemptId)) {
            if (doc.links().isDocumentBeingRemoved()) {
                return Mono.just(Optional.empty());
            }
            return Mono.just(Optional.of(TransactionGetResult.createFrom(doc, doc.links().stagedContent().get().getBytes(StandardCharsets.UTF_8), TransactionJsonDocumentStatus.OWN_WRITE)));
        }
        return ForwardCompatibility.check(ForwardCompatibilityStages.GETS_READING_ATR, entry.forwardCompatibility(), logger, Supported.SUPPORTED).then(Mono.defer(() -> {
            logger.info(byAttemptId, "found ATR for MAV read in state: %s", entry);
            switch (entry.state()) {
                case COMMITTED: 
                case COMPLETED: {
                    if (doc.links().isDocumentBeingRemoved()) {
                        return Mono.just(Optional.empty());
                    }
                    return Mono.just(Optional.of(TransactionGetResult.createFrom(doc, doc.links().stagedContent().get().getBytes(StandardCharsets.UTF_8), TransactionJsonDocumentStatus.IN_TXN_COMMITTED)));
                }
            }
            if (doc.links().op().isPresent() && doc.links().op().get().equals("insert")) {
                return Mono.just(Optional.empty());
            }
            return Mono.just(Optional.of(TransactionGetResult.createFrom(doc, doc.contentAsBytes(), TransactionJsonDocumentStatus.IN_TXN_OTHER)));
        }));
    }
}

