/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.transactions.TransactionDurabilityLevel;
import com.couchbase.transactions.config.PerTransactionConfig;
import com.couchbase.transactions.config.PerTransactionQueryConfigBuilder;
import com.couchbase.transactions.support.AttemptContextFactory;
import java.time.Duration;
import java.util.Optional;

public class PerTransactionConfigBuilder {
    private Optional<TransactionDurabilityLevel> durabilityLevel = Optional.empty();
    private Optional<PerTransactionQueryConfigBuilder> queryConfig = Optional.empty();
    private Optional<RequestSpan> parentSpan = Optional.empty();
    private Optional<Duration> expirationTime = Optional.empty();
    private Optional<Duration> keyValueTimeout = Optional.empty();
    private Optional<AttemptContextFactory> attemptContextFactory = Optional.empty();

    public static PerTransactionConfigBuilder create() {
        return new PerTransactionConfigBuilder();
    }

    public PerTransactionConfig build() {
        return new PerTransactionConfig(this.durabilityLevel, this.queryConfig.flatMap(v -> v.scanConsistency()), this.parentSpan, this.expirationTime, this.keyValueTimeout, this.attemptContextFactory);
    }

    private PerTransactionConfigBuilder() {
    }

    public PerTransactionConfigBuilder durabilityLevel(TransactionDurabilityLevel durabilityLevel) {
        this.durabilityLevel = Optional.of(durabilityLevel);
        return this;
    }

    public PerTransactionConfigBuilder queryConfig(PerTransactionQueryConfigBuilder queryConfig) {
        this.queryConfig = Optional.of(queryConfig);
        return this;
    }

    public PerTransactionConfigBuilder parentSpan(RequestSpan parentSpan) {
        this.parentSpan = Optional.of(parentSpan);
        return this;
    }

    public PerTransactionConfigBuilder expirationTime(Duration expirationTime) {
        this.expirationTime = Optional.of(expirationTime);
        return this;
    }

    public PerTransactionConfigBuilder keyValueTimeout(Duration timeout) {
        this.keyValueTimeout = Optional.of(timeout);
        return this;
    }

    @Stability.Internal
    PerTransactionConfigBuilder testFactory(AttemptContextFactory attemptContextFactory) {
        this.attemptContextFactory = Optional.of(attemptContextFactory);
        return this;
    }
}

