/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.transactions.TransactionDurabilityLevel;
import com.couchbase.transactions.TransactionQueryOptions;
import com.couchbase.transactions.config.SingleQueryTransactionConfig;
import com.couchbase.transactions.support.AttemptContextFactory;
import java.time.Duration;
import java.util.Optional;

@Stability.Uncommitted
public class SingleQueryTransactionConfigBuilder {
    private Optional<RequestSpan> parentSpan = Optional.empty();
    private TransactionQueryOptions queryOptions = TransactionQueryOptions.queryOptions();
    private Optional<TransactionDurabilityLevel> durabilityLevel = Optional.empty();
    private Optional<Duration> expirationTime = Optional.empty();
    private Optional<AttemptContextFactory> attemptContextFactory = Optional.empty();

    public static SingleQueryTransactionConfigBuilder create() {
        return new SingleQueryTransactionConfigBuilder();
    }

    public SingleQueryTransactionConfigBuilder parentSpan(RequestSpan parentSpan) {
        this.parentSpan = Optional.of(parentSpan);
        return this;
    }

    public SingleQueryTransactionConfigBuilder queryOptions(TransactionQueryOptions queryOptions) {
        this.queryOptions = queryOptions;
        return this;
    }

    @Stability.Internal
    public SingleQueryTransactionConfig build() {
        return new SingleQueryTransactionConfig(this.parentSpan, this.queryOptions, this.durabilityLevel, this.expirationTime, this.attemptContextFactory);
    }

    public SingleQueryTransactionConfigBuilder expirationTime(Duration expirationTime) {
        this.expirationTime = Optional.of(expirationTime);
        return this;
    }

    public SingleQueryTransactionConfigBuilder durabilityLevel(TransactionDurabilityLevel durabilityLevel) {
        this.durabilityLevel = Optional.of(durabilityLevel);
        return this;
    }

    @Stability.Internal
    SingleQueryTransactionConfigBuilder testFactory(AttemptContextFactory attemptContextFactory) {
        this.attemptContextFactory = Optional.of(attemptContextFactory);
        return this;
    }
}

