/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.transactions.TransactionGetResult;
import com.couchbase.transactions.util.LogDeferDocId;
import com.couchbase.transactions.util.LogDeferThrowable;

@Stability.Internal
public class DebugUtil {
    private DebugUtil() {
    }

    public static LogDeferThrowable dbg(Throwable err) {
        if (err == null) {
            return null;
        }
        return new LogDeferThrowable(err);
    }

    public static LogDeferDocId docId(ReactiveCollection collection, String docId) {
        return new LogDeferDocId(collection, docId);
    }

    public static LogDeferDocId docId(TransactionGetResult doc) {
        return DebugUtil.docId(doc.collection(), doc.id());
    }

    public static String createElidedStacktrace(Throwable err) {
        StackTraceElement[] st;
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement s : st = err.getStackTrace()) {
            String str = s.toString();
            if (str.startsWith("reactor.") || str.startsWith("java.") || str.startsWith("com.couchbase.client.core") || sb.length() <= 0) continue;
            sb.append((CharSequence)sb);
            sb.append("; ");
        }
        return sb.toString();
    }
}

