/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.util;

import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DocumentExistsException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.ErrorCodeAndMessage;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.error.TimeoutException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.error.context.QueryErrorContext;
import com.couchbase.transactions.error.external.TransactionOperationFailed;
import com.couchbase.transactions.error.internal.AttemptExpired;
import com.couchbase.transactions.error.internal.AttemptNotFoundOnQuery;
import com.couchbase.transactions.error.internal.ErrorClasses;
import com.couchbase.transactions.error.internal.TransactionOperationFailedBuilder;
import java.util.Map;

public class QueryUtil {
    private QueryUtil() {
    }

    public static RuntimeException convertQueryError(Throwable err) {
        QueryErrorContext ctx;
        CouchbaseException ce;
        if (err instanceof TimeoutException) {
            return TransactionOperationFailedBuilder.createError(ErrorClasses.FAIL_EXPIRY).raiseException(TransactionOperationFailed.FinalErrorToRaise.TRANSACTION_EXPIRED).cause(err).doNotRollbackAttempt().build();
        }
        if (err instanceof CouchbaseException && (ce = (CouchbaseException)err).context() instanceof QueryErrorContext && (ctx = (QueryErrorContext)ce.context()).errors().size() >= 1) {
            ErrorCodeAndMessage chosenError = QueryUtil.chooseQueryError(ctx);
            int code = chosenError.code();
            switch (code) {
                case 1065: {
                    return TransactionOperationFailedBuilder.createError(ErrorClasses.FAIL_OTHER).cause((Throwable)new FeatureNotAvailableException("Unknown query parameter: note that query support in transactions is available from Couchbase Server 7.0 onwards", err)).build();
                }
                case 17004: {
                    return new AttemptNotFoundOnQuery();
                }
                case 1080: 
                case 17010: {
                    return TransactionOperationFailedBuilder.createError(ErrorClasses.FAIL_EXPIRY).cause((Throwable)((Object)new AttemptExpired(err))).doNotRollbackAttempt().raiseException(TransactionOperationFailed.FinalErrorToRaise.TRANSACTION_EXPIRED).build();
                }
                case 17012: {
                    return new DocumentExistsException((ErrorContext)ctx);
                }
                case 17014: {
                    return new DocumentNotFoundException((ErrorContext)ctx);
                }
                case 17015: {
                    return new CasMismatchException((ErrorContext)ctx);
                }
            }
            if (chosenError.context().containsKey("cause")) {
                Map cause = (Map)chosenError.context().get("cause");
                Boolean rollbackRaw = (Boolean)cause.get("rollback");
                Boolean retryRaw = (Boolean)cause.get("retry");
                String raise = (String)cause.get("raise");
                TransactionOperationFailedBuilder builder = TransactionOperationFailedBuilder.createError(ErrorClasses.FAIL_OTHER).cause(err);
                switch (raise) {
                    case "failed_post_commit": {
                        builder.raiseException(TransactionOperationFailed.FinalErrorToRaise.TRANSACTION_FAILED_POST_COMMIT);
                        break;
                    }
                    case "commit_ambiguous": {
                        builder.raiseException(TransactionOperationFailed.FinalErrorToRaise.TRANSACTION_COMMIT_AMBIGUOUS);
                        break;
                    }
                    case "expired": {
                        builder.raiseException(TransactionOperationFailed.FinalErrorToRaise.TRANSACTION_EXPIRED);
                        break;
                    }
                    default: {
                        builder.raiseException(TransactionOperationFailed.FinalErrorToRaise.TRANSACTION_FAILED);
                    }
                }
                if (retryRaw != null && retryRaw.booleanValue()) {
                    builder.retryTransaction();
                }
                if (rollbackRaw != null && !rollbackRaw.booleanValue()) {
                    builder.doNotRollbackAttempt();
                }
                return builder.build();
            }
        }
        return null;
    }

    public static ErrorCodeAndMessage chooseQueryError(QueryErrorContext ctx) {
        for (ErrorCodeAndMessage err : ctx.errors()) {
            if (!err.context().containsKey("cause")) continue;
            return err;
        }
        for (ErrorCodeAndMessage err : ctx.errors()) {
            if (err.code() < 17000 || err.code() > 18000) continue;
            return err;
        }
        return (ErrorCodeAndMessage)ctx.errors().get(0);
    }
}

