/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;

public enum DcpFailoverLogResponse {


    public static boolean is(ByteBuf buffer) {
        return buffer.getByte(0) == -127 && buffer.getByte(1) == 84;
    }

    public static void init(ByteBuf buffer) {
        MessageUtil.initResponse((byte)84, buffer);
    }

    public static void vbucket(ByteBuf buffer, short vbid) {
        MessageUtil.setVbucket(vbid, buffer);
    }

    public static short vbucket(ByteBuf buffer) {
        int vbOffset = MessageUtil.getContent(buffer).readableBytes() - 2;
        return MessageUtil.getContent(buffer).getShort(vbOffset);
    }

    public static int numLogEntries(ByteBuf buffer) {
        return (MessageUtil.getContent(buffer).readableBytes() - 2) / 16;
    }

    public static long vbuuidEntry(ByteBuf buffer, int index) {
        return MessageUtil.getContent(buffer).getLong(index * 16);
    }

    public static long seqnoEntry(ByteBuf buffer, int index) {
        return MessageUtil.getContent(buffer).getLong(index * 16 + 8);
    }

    public static String toString(ByteBuf buffer) {
        StringBuilder sb = new StringBuilder();
        sb.append("FailoverLog [");
        sb.append("vbid: ").append(DcpFailoverLogResponse.vbucket(buffer)).append(", log: [");
        int numEntries = DcpFailoverLogResponse.numLogEntries(buffer);
        for (int i = 0; i < numEntries; ++i) {
            sb.append("[uuid: ").append(DcpFailoverLogResponse.vbuuidEntry(buffer, i)).append(", seqno: ").append(DcpFailoverLogResponse.seqnoEntry(buffer, i)).append("]");
        }
        return sb.append("]]").toString();
    }
}

