/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.dcp.config.ClientEnvironment;
import com.couchbase.client.dcp.config.DcpControl;
import com.couchbase.client.dcp.message.DcpBufferAckRequest;
import com.couchbase.client.dcp.message.DcpCloseStreamResponse;
import com.couchbase.client.dcp.message.DcpDeletionMessage;
import com.couchbase.client.dcp.message.DcpExpirationMessage;
import com.couchbase.client.dcp.message.DcpMutationMessage;
import com.couchbase.client.dcp.message.DcpSnapshotMarkerRequest;
import com.couchbase.client.dcp.message.DcpStateVbucketStateMessage;
import com.couchbase.client.dcp.message.DcpStreamEndMessage;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.channel.Channel;

public class ChannelFlowController {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(ChannelFlowController.class);
    private final Channel channel;
    private final boolean needsBufferAck;
    private final int bufferAckWatermark;
    private int bufferAckCounter;

    public ChannelFlowController(Channel channel, ClientEnvironment environment) {
        this.channel = channel;
        this.needsBufferAck = environment.dcpControl().bufferAckEnabled();
        if (this.needsBufferAck) {
            int bufferAckPercent = environment.bufferAckWatermark();
            int bufferSize = Integer.parseInt(environment.dcpControl().get(DcpControl.Names.CONNECTION_BUFFER_SIZE));
            this.bufferAckWatermark = (int)Math.round((double)bufferSize / 100.0 * (double)bufferAckPercent);
            LOGGER.debug("BufferAckWatermark absolute is {}", (Object)this.bufferAckWatermark);
        } else {
            this.bufferAckWatermark = 0;
        }
        this.bufferAckCounter = 0;
    }

    public void ack(ByteBuf message) {
        if (this.needsBufferAck && (DcpStateVbucketStateMessage.is(message) || DcpSnapshotMarkerRequest.is(message) || DcpStreamEndMessage.is(message) || DcpCloseStreamResponse.is(message) || DcpMutationMessage.is(message) || DcpDeletionMessage.is(message) || DcpExpirationMessage.is(message))) {
            this.ack(message.readableBytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(int numBytes) {
        if (this.needsBufferAck) {
            ChannelFlowController channelFlowController = this;
            synchronized (channelFlowController) {
                this.bufferAckCounter += numBytes;
                LOGGER.trace("BufferAckCounter is now {}", (Object)this.bufferAckCounter);
                if (this.bufferAckCounter >= this.bufferAckWatermark) {
                    LOGGER.trace("BufferAckWatermark reached on {}, acking now against the server.", (Object)this.channel.remoteAddress());
                    ByteBuf buffer = this.channel.alloc().buffer();
                    DcpBufferAckRequest.init(buffer);
                    DcpBufferAckRequest.ackBytes(buffer, this.bufferAckCounter);
                    this.channel.writeAndFlush((Object)buffer);
                    this.bufferAckCounter = 0;
                }
                LOGGER.trace("Acknowledging {} bytes against connection {}.", (Object)numBytes, (Object)this.channel.remoteAddress());
            }
        }
    }
}

