/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.parser.BucketConfigParser;
import com.couchbase.client.core.env.ConfigParserEnvironment;
import com.couchbase.client.dcp.config.ClientEnvironment;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.channel.SimpleChannelInboundHandler;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpContent;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpObject;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.net.InetSocketAddress;
import rx.subjects.Subject;

class ConfigHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private final InetSocketAddress hostname;
    private final Subject<CouchbaseBucketConfig, CouchbaseBucketConfig> configStream;
    private final ClientEnvironment environment;
    private ByteBuf responseContent;

    ConfigHandler(InetSocketAddress hostname, Subject<CouchbaseBucketConfig, CouchbaseBucketConfig> configStream, ClientEnvironment environment) {
        this.hostname = hostname;
        this.configStream = configStream;
        this.environment = environment;
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            this.decodeChunk(content.content());
        }
    }

    private void decodeChunk(ByteBuf chunk) {
        this.responseContent.writeBytes(chunk);
        String currentChunk = this.responseContent.toString(CharsetUtil.UTF_8);
        int separatorIndex = currentChunk.indexOf("\n\n\n\n");
        if (separatorIndex > 0) {
            String rawConfig = currentChunk.substring(0, separatorIndex).trim().replace("$HOST", this.hostname.getAddress().getHostAddress());
            this.configStream.onNext((Object)((CouchbaseBucketConfig)BucketConfigParser.parse((String)rawConfig, (ConfigParserEnvironment)this.environment)));
            this.responseContent.clear();
            this.responseContent.writeBytes(currentChunk.substring(separatorIndex + 4).getBytes(CharsetUtil.UTF_8));
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.responseContent = ctx.alloc().buffer();
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.responseContent != null && this.responseContent.refCnt() > 0) {
            this.responseContent.release();
            this.responseContent = null;
        }
    }
}

