/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.dcp.config.ClientEnvironment;
import com.couchbase.client.dcp.config.SSLEngineFactory;
import com.couchbase.client.dcp.transport.netty.ConfigHandler;
import com.couchbase.client.dcp.transport.netty.StartStreamHandler;
import com.couchbase.client.deps.io.netty.channel.Channel;
import com.couchbase.client.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.deps.io.netty.channel.ChannelInitializer;
import com.couchbase.client.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpClientCodec;
import com.couchbase.client.deps.io.netty.handler.logging.LogLevel;
import com.couchbase.client.deps.io.netty.handler.logging.LoggingHandler;
import com.couchbase.client.deps.io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import rx.subjects.Subject;

public class ConfigPipeline
extends ChannelInitializer<Channel> {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(ConfigPipeline.class);
    private final ClientEnvironment environment;
    private final InetSocketAddress hostname;
    private final String bucket;
    private final String username;
    private final String password;
    private final Subject<CouchbaseBucketConfig, CouchbaseBucketConfig> configStream;
    private final SSLEngineFactory sslEngineFactory;

    public ConfigPipeline(ClientEnvironment environment, InetSocketAddress hostname, Subject<CouchbaseBucketConfig, CouchbaseBucketConfig> configStream) {
        this.hostname = hostname;
        this.bucket = environment.bucket();
        this.username = environment.username();
        this.password = environment.password();
        this.configStream = configStream;
        this.environment = environment;
        this.sslEngineFactory = environment.sslEnabled() ? new SSLEngineFactory(environment) : null;
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.environment.sslEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new SslHandler(this.sslEngineFactory.get())});
        }
        if (LOGGER.isTraceEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.TRACE)});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()}).addLast(new ChannelHandler[]{new StartStreamHandler(this.bucket, this.username, this.password)}).addLast(new ChannelHandler[]{new ConfigHandler(this.hostname, this.configStream, this.environment)});
    }
}

