/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.dcp.ConnectionNameGenerator;
import com.couchbase.client.dcp.message.BucketSelectRequest;
import com.couchbase.client.dcp.message.DcpOpenConnectionRequest;
import com.couchbase.client.dcp.message.HelloRequest;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.message.VersionRequest;
import com.couchbase.client.dcp.transport.netty.ConnectInterceptingHandler;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.nio.charset.Charset;

public class DcpConnectHandler
extends ConnectInterceptingHandler<ByteBuf> {
    private static final byte SUCCESS = 0;
    private static final byte VERSION = 0;
    private static final byte HELLO = 1;
    private static final byte SELECT = 2;
    private static final byte OPEN = 3;
    private static final byte REMOVE = 4;
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(DcpConnectHandler.class);
    private final ConnectionNameGenerator connectionNameGenerator;
    private String connectionName;
    private final String bucket;
    private byte step = 0;

    DcpConnectHandler(ConnectionNameGenerator connectionNameGenerator, String bucket) {
        this.connectionNameGenerator = connectionNameGenerator;
        this.bucket = bucket;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ByteBuf request = ctx.alloc().buffer();
        VersionRequest.init(request);
        ctx.writeAndFlush((Object)request);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        short status = MessageUtil.getStatus(msg);
        if (status == 0) {
            this.step = (byte)(this.step + 1);
            switch (this.step) {
                case 1: {
                    this.hello(ctx, msg);
                    break;
                }
                case 2: {
                    this.select(ctx);
                    break;
                }
                case 3: {
                    this.open(ctx);
                    break;
                }
                case 4: {
                    this.remove(ctx);
                    break;
                }
                default: {
                    this.originalPromise().setFailure((Throwable)new IllegalStateException("Unidentified DcpConnection step " + this.step));
                    break;
                }
            }
        } else {
            this.originalPromise().setFailure((Throwable)new IllegalStateException("Could not open DCP Connection: Failed in the " + this.toString(this.step) + " step, response status is " + status));
        }
    }

    private String toString(byte step) {
        switch (step) {
            case 0: {
                return "VERSION";
            }
            case 1: {
                return "HELLO";
            }
            case 2: {
                return "SELECT";
            }
            case 3: {
                return "OPEN";
            }
            case 4: {
                return "REMOVE";
            }
        }
        return "UNKNOWN";
    }

    private void select(ChannelHandlerContext ctx) {
        ByteBuf request = ctx.alloc().buffer();
        BucketSelectRequest.init(request, this.bucket);
        ctx.writeAndFlush((Object)request);
    }

    private void remove(ChannelHandlerContext ctx) {
        ctx.pipeline().remove((ChannelHandler)this);
        this.originalPromise().setSuccess();
        ctx.fireChannelActive();
        LOGGER.debug("DCP Connection opened with Name \"{}\" against Node {}", (Object)this.connectionName, (Object)ctx.channel().remoteAddress());
    }

    private void open(ChannelHandlerContext ctx) {
        ByteBuf request = ctx.alloc().buffer();
        DcpOpenConnectionRequest.init(request);
        DcpOpenConnectionRequest.connectionName(request, Unpooled.copiedBuffer((CharSequence)this.connectionName, (Charset)CharsetUtil.UTF_8));
        ctx.writeAndFlush((Object)request);
    }

    private void hello(ChannelHandlerContext ctx, ByteBuf msg) {
        int majorVersion;
        this.connectionName = this.connectionNameGenerator.name();
        String response = MessageUtil.getContent(msg).toString(CharsetUtil.UTF_8);
        try {
            majorVersion = Integer.parseInt(response.substring(0, 1));
        }
        catch (NumberFormatException e) {
            this.originalPromise().setFailure((Throwable)new IllegalStateException("Version returned by the server couldn't be parsed " + response, e));
            ctx.close(ctx.voidPromise());
            return;
        }
        if (majorVersion < 5) {
            this.step = (byte)3;
            this.open(ctx);
        } else {
            ByteBuf request = ctx.alloc().buffer();
            HelloRequest.init(request, Unpooled.copiedBuffer((CharSequence)this.connectionName, (Charset)CharsetUtil.UTF_8));
            ctx.writeAndFlush((Object)request);
        }
    }
}

