/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.dcp.config.DcpControl;
import com.couchbase.client.dcp.message.DcpControlRequest;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.transport.netty.ConnectInterceptingHandler;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;

public class DcpControlHandler
extends ConnectInterceptingHandler<ByteBuf> {
    private static final byte CONTROL_SUCCESS = 0;
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(DcpControlHandler.class);
    private final Iterator<Map.Entry<String, String>> controlSettings;

    DcpControlHandler(DcpControl dcpControl) {
        this.controlSettings = dcpControl.iterator();
    }

    private void negotiate(ChannelHandlerContext ctx) {
        if (this.controlSettings.hasNext()) {
            Map.Entry<String, String> setting = this.controlSettings.next();
            LOGGER.debug("Negotiating DCP Control {}: {}", (Object)setting.getKey(), (Object)setting.getValue());
            ByteBuf request = ctx.alloc().buffer();
            DcpControlRequest.init(request);
            DcpControlRequest.key(Unpooled.copiedBuffer((CharSequence)setting.getKey(), (Charset)CharsetUtil.UTF_8), request);
            DcpControlRequest.value(Unpooled.copiedBuffer((CharSequence)setting.getValue(), (Charset)CharsetUtil.UTF_8), request);
            ctx.writeAndFlush((Object)request);
        } else {
            this.originalPromise().setSuccess();
            ctx.pipeline().remove((ChannelHandler)this);
            ctx.fireChannelActive();
            LOGGER.debug("Negotiated all DCP Control settings against Node {}", (Object)ctx.channel().remoteAddress());
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.negotiate(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        short status = MessageUtil.getStatus(msg);
        if (status == 0) {
            this.negotiate(ctx);
        } else {
            this.originalPromise().setFailure((Throwable)new IllegalStateException("Could not configure DCP Controls: " + status));
        }
    }
}

