/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.buffer;

import com.couchbase.client.dcp.buffer.NodeToPartitionMultimap;
import com.couchbase.client.dcp.buffer.PartitionInstance;
import com.couchbase.client.dcp.config.HostAndPort;
import com.couchbase.client.dcp.core.CouchbaseException;
import com.couchbase.client.dcp.core.config.AlternateAddress;
import com.couchbase.client.dcp.core.config.CouchbaseBucketConfig;
import com.couchbase.client.dcp.core.config.DefaultNodeInfo;
import com.couchbase.client.dcp.core.config.NodeInfo;
import com.couchbase.client.dcp.core.logging.RedactableArgument;
import com.couchbase.client.dcp.core.service.ServiceType;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;

public class DcpBucketConfig {
    private final boolean sslEnabled;
    private final CouchbaseBucketConfig config;
    private final NodeToPartitionMultimap map;
    private final List<NodeInfo> allNodes;
    private final List<NodeInfo> allDataNodes;

    public DcpBucketConfig(CouchbaseBucketConfig config, boolean sslEnabled) {
        this.config = Objects.requireNonNull(config);
        this.sslEnabled = sslEnabled;
        this.map = new NodeToPartitionMultimap(config);
        this.allNodes = DcpBucketConfig.resolveAlternateAddresses(config);
        this.allDataNodes = Collections.unmodifiableList(this.allNodes.stream().filter(this::hasBinaryService).collect(Collectors.toList()));
    }

    public long rev() {
        return this.config.rev();
    }

    public int numberOfPartitions() {
        return this.config.numberOfPartitions();
    }

    public List<NodeInfo> nodes() {
        return this.allNodes;
    }

    private static List<NodeInfo> resolveAlternateAddresses(CouchbaseBucketConfig config) {
        return config.nodes().stream().map(DcpBucketConfig::resolveAlternateAddress).collect(Collectors.toList());
    }

    private static NodeInfo resolveAlternateAddress(NodeInfo nodeInfo) {
        String networkName = nodeInfo.useAlternateNetwork();
        if (networkName == null) {
            return nodeInfo;
        }
        AlternateAddress alternate = nodeInfo.alternateAddresses().get(networkName);
        if (alternate == null) {
            throw new CouchbaseException("Node " + RedactableArgument.system(nodeInfo.hostname()) + " has no alternate hostname for network [" + networkName + "]");
        }
        HashMap<ServiceType, Integer> services = new HashMap<ServiceType, Integer>(nodeInfo.services());
        HashMap<ServiceType, Integer> sslServices = new HashMap<ServiceType, Integer>(nodeInfo.sslServices());
        services.putAll(alternate.services());
        sslServices.putAll(alternate.sslServices());
        return new DefaultNodeInfo(alternate.hostname(), services, sslServices, Collections.emptyMap());
    }

    public List<PartitionInstance> getHostedPartitions(InetSocketAddress nodeAddress) throws NoSuchElementException {
        int nodeIndex = this.getNodeIndex(nodeAddress);
        return this.map.get(nodeIndex);
    }

    public List<NodeInfo> getDataNodes() {
        return this.allDataNodes;
    }

    public int getNodeIndex(InetSocketAddress nodeAddress) throws NoSuchElementException {
        int nodeIndex = 0;
        for (NodeInfo node : this.nodes()) {
            if (nodeAddress.equals(this.getAddress(node))) {
                return nodeIndex;
            }
            ++nodeIndex;
        }
        throw new NoSuchElementException("Failed to locate " + RedactableArgument.system(nodeAddress) + " in bucket config.");
    }

    public HostAndPort getActiveNodeKvAddress(int partition) {
        short index = this.config.nodeIndexForMaster(partition, false);
        NodeInfo node = this.nodes().get(index);
        int port = this.getServicePortMap(node).get((Object)ServiceType.BINARY);
        return new HostAndPort(node.hostname(), port);
    }

    public List<PartitionInstance> getAbsentPartitionInstances() {
        return this.map.getAbsent();
    }

    public InetSocketAddress getAddress(NodeInfo node) {
        int port = this.getServicePortMap(node).get((Object)ServiceType.BINARY);
        return new InetSocketAddress(node.hostname(), port);
    }

    private Map<ServiceType, Integer> getServicePortMap(NodeInfo node) {
        return this.sslEnabled ? node.sslServices() : node.services();
    }

    private boolean hasBinaryService(NodeInfo node) {
        return this.getServicePortMap(node).containsKey((Object)ServiceType.BINARY);
    }

    public int numberOfReplicas() {
        return this.config.numberOfReplicas();
    }
}

