/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.buffer;

import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.state.FailoverLogEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class FailoverLogResponse {
    private final List<FailoverLogEntry> logEntries;

    public FailoverLogResponse(ByteBuf response) {
        ByteBuf content = MessageUtil.getContent(response);
        int numEntries = content.readableBytes() / 16;
        ArrayList<FailoverLogEntry> entries = new ArrayList<FailoverLogEntry>(numEntries);
        for (int i = 0; i < numEntries; ++i) {
            long vbuuid = content.readLong();
            long seqno = content.readLong();
            entries.add(new FailoverLogEntry(seqno, vbuuid));
        }
        this.logEntries = Collections.unmodifiableList(entries);
    }

    public List<FailoverLogEntry> getFailoverLogEntries() {
        return this.logEntries;
    }

    public long getCurrentVbuuid() {
        return this.logEntries.get(0).getUuid();
    }

    public String toString() {
        return this.logEntries.toString();
    }
}

