/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.config;

import com.couchbase.client.dcp.ConnectionNameGenerator;
import com.couchbase.client.dcp.ControlEventHandler;
import com.couchbase.client.dcp.CredentialsProvider;
import com.couchbase.client.dcp.DataEventHandler;
import com.couchbase.client.dcp.SystemEventHandler;
import com.couchbase.client.dcp.buffer.PersistedSeqnos;
import com.couchbase.client.dcp.buffer.StreamEventBuffer;
import com.couchbase.client.dcp.config.DcpControl;
import com.couchbase.client.dcp.config.HostAndPort;
import com.couchbase.client.dcp.config.SecureEnvironment;
import com.couchbase.client.dcp.core.env.CoreScheduler;
import com.couchbase.client.dcp.core.env.NetworkResolution;
import com.couchbase.client.dcp.core.env.resources.NoOpShutdownHook;
import com.couchbase.client.dcp.core.env.resources.ShutdownHook;
import com.couchbase.client.dcp.core.event.CouchbaseEvent;
import com.couchbase.client.dcp.core.event.EventBus;
import com.couchbase.client.dcp.core.event.EventType;
import com.couchbase.client.dcp.core.time.Delay;
import com.couchbase.client.dcp.deps.io.netty.channel.EventLoopGroup;
import com.couchbase.client.dcp.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.dcp.deps.io.netty.util.concurrent.GenericFutureListener;
import com.couchbase.client.dcp.events.DefaultDcpEventBus;
import java.security.KeyStore;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Completable;
import rx.CompletableSubscriber;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;

public class ClientEnvironment
implements SecureEnvironment {
    private static final Logger log = LoggerFactory.getLogger(ClientEnvironment.class);
    public static final Duration DEFAULT_BOOTSTRAP_TIMEOUT = Duration.ofSeconds(5L);
    public static final Duration DEFAULT_CONFIG_REFRESH_INTERVAL = Duration.ofSeconds(2L);
    public static final long DEFAULT_CONNECT_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    public static final long DEFAULT_SOCKET_CONNECT_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    public static final Delay DEFAULT_DCP_CHANNELS_RECONNECT_DELAY = Delay.fixed(200L, TimeUnit.MILLISECONDS);
    public static final int DEFAULT_DCP_CHANNELS_RECONNECT_MAX_ATTEMPTS = Integer.MAX_VALUE;
    public static final boolean DEFAULT_SSL_ENABLED = false;
    private static final int DEFAULT_KV_PORT = 11210;
    private static final int DEFAULT_KV_TLS_PORT = 11207;
    private final List<HostAndPort> clusterAt;
    private final NetworkResolution networkResolution;
    private final ConnectionNameGenerator connectionNameGenerator;
    private final String bucket;
    private final boolean collectionsAware;
    private final OptionalLong scopeId;
    private final Optional<String> scopeName;
    private final Set<Long> collectionIds;
    private final Set<String> collectionNames;
    private final CredentialsProvider credentialsProvider;
    private final Duration bootstrapTimeout;
    private final Duration configRefreshInterval;
    private final long connectTimeout;
    private final DcpControl dcpControl;
    private final EventLoopGroup eventLoopGroup;
    private final boolean eventLoopGroupIsPrivate;
    private final boolean poolBuffers;
    private final int bufferAckWatermark;
    private final long socketConnectTimeout;
    private final long persistencePollingIntervalMillis;
    private volatile DataEventHandler dataEventHandler;
    private volatile ControlEventHandler controlEventHandler;
    private final PersistedSeqnos persistedSeqnos = PersistedSeqnos.uninitialized();
    private final Delay dcpChannelsReconnectDelay;
    private final int dcpChannelsReconnectMaxAttempts;
    private final EventBus eventBus;
    private final Scheduler scheduler;
    private final ShutdownHook schedulerShutdownHook;
    private Subscription systemEventSubscription;
    private final boolean sslEnabled;
    private final String sslKeystoreFile;
    private final String sslKeystorePassword;
    private final KeyStore sslKeystore;

    private ClientEnvironment(Builder builder) {
        this.connectionNameGenerator = builder.connectionNameGenerator;
        this.bucket = builder.bucket;
        this.credentialsProvider = builder.credentialsProvider;
        this.bootstrapTimeout = builder.bootstrapTimeout;
        this.configRefreshInterval = builder.configRefreshInterval;
        this.connectTimeout = builder.connectTimeout;
        this.dcpControl = builder.dcpControl;
        this.eventLoopGroup = builder.eventLoopGroup;
        this.eventLoopGroupIsPrivate = builder.eventLoopGroupIsPrivate;
        this.bufferAckWatermark = builder.bufferAckWatermark;
        this.poolBuffers = builder.poolBuffers;
        this.socketConnectTimeout = builder.socketConnectTimeout;
        this.dcpChannelsReconnectDelay = builder.dcpChannelsReconnectDelay;
        this.dcpChannelsReconnectMaxAttempts = builder.dcpChannelsReconnectMaxAttempts;
        this.collectionsAware = builder.collectionsAware;
        this.collectionIds = Collections.unmodifiableSet(builder.collectionIds);
        this.collectionNames = Collections.unmodifiableSet(builder.collectionNames);
        this.scopeId = builder.scopeId;
        this.scopeName = builder.scopeName;
        if (builder.eventBus != null) {
            this.eventBus = builder.eventBus;
            this.scheduler = null;
            this.schedulerShutdownHook = new NoOpShutdownHook();
        } else {
            CoreScheduler scheduler = new CoreScheduler(3);
            this.scheduler = scheduler;
            this.schedulerShutdownHook = scheduler;
            this.eventBus = new DefaultDcpEventBus(scheduler);
        }
        this.sslEnabled = builder.sslEnabled;
        this.sslKeystoreFile = builder.sslKeystoreFile;
        this.sslKeystorePassword = builder.sslKeystorePassword;
        this.sslKeystore = builder.sslKeystore;
        this.clusterAt = builder.clusterAt;
        this.networkResolution = builder.networkResolution;
        this.persistencePollingIntervalMillis = builder.persistencePollingIntervalMillis;
        if (this.persistencePollingIntervalMillis > 0L) {
            if (this.bufferAckWatermark == 0) {
                throw new IllegalArgumentException("Rollback mitigation requires flow control.");
            }
            StreamEventBuffer buffer = new StreamEventBuffer(this.eventBus);
            this.dataEventHandler = buffer;
            this.controlEventHandler = buffer;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<HostAndPort> clusterAt() {
        return this.clusterAt;
    }

    public NetworkResolution networkResolution() {
        return this.networkResolution;
    }

    public DataEventHandler dataEventHandler() {
        return this.dataEventHandler;
    }

    public StreamEventBuffer streamEventBuffer() {
        try {
            return (StreamEventBuffer)this.dataEventHandler;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Stream event buffer not configured");
        }
    }

    public PersistedSeqnos persistedSeqnos() {
        return this.persistedSeqnos;
    }

    public long persistencePollingIntervalMillis() {
        return this.persistencePollingIntervalMillis;
    }

    public boolean persistencePollingEnabled() {
        return this.persistencePollingIntervalMillis > 0L;
    }

    public ControlEventHandler controlEventHandler() {
        return this.controlEventHandler;
    }

    public ConnectionNameGenerator connectionNameGenerator() {
        return this.connectionNameGenerator;
    }

    public String bucket() {
        return this.bucket;
    }

    public boolean collectionsAware() {
        return this.collectionsAware;
    }

    public Set<Long> collectionIds() {
        return this.collectionIds;
    }

    public Set<String> collectionNames() {
        return this.collectionNames;
    }

    public OptionalLong scopeId() {
        return this.scopeId;
    }

    public Optional<String> scopeName() {
        return this.scopeName;
    }

    public CredentialsProvider credentialsProvider() {
        return this.credentialsProvider;
    }

    @Deprecated
    public String username() {
        return this.credentialsProvider.get(null).getUsername();
    }

    @Deprecated
    public String password() {
        return this.credentialsProvider.get(null).getPassword();
    }

    public DcpControl dcpControl() {
        return this.dcpControl;
    }

    public int bufferAckWatermark() {
        return this.bufferAckWatermark;
    }

    public EventLoopGroup eventLoopGroup() {
        return this.eventLoopGroup;
    }

    public Duration configRefreshInterval() {
        return this.configRefreshInterval;
    }

    public Duration bootstrapTimeout() {
        return this.bootstrapTimeout;
    }

    public long connectTimeout() {
        return this.connectTimeout;
    }

    public void setDataEventHandler(DataEventHandler dataEventHandler) {
        if (this.persistencePollingEnabled()) {
            this.streamEventBuffer().setDataEventHandler(dataEventHandler);
        } else {
            this.dataEventHandler = dataEventHandler;
        }
    }

    public void setControlEventHandler(ControlEventHandler controlEventHandler) {
        if (this.persistencePollingEnabled()) {
            this.streamEventBuffer().setControlEventHandler(controlEventHandler);
        } else {
            this.controlEventHandler = controlEventHandler;
        }
    }

    public void setSystemEventHandler(final SystemEventHandler systemEventHandler) {
        if (this.systemEventSubscription != null) {
            this.systemEventSubscription.unsubscribe();
        }
        if (systemEventHandler != null) {
            this.systemEventSubscription = this.eventBus().get().filter(evt -> evt.type().equals((Object)EventType.SYSTEM)).subscribe((Subscriber)new Subscriber<CouchbaseEvent>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                }

                public void onNext(CouchbaseEvent evt) {
                    systemEventHandler.onEvent(evt);
                }
            });
        }
    }

    public boolean poolBuffers() {
        return this.poolBuffers;
    }

    public long socketConnectTimeout() {
        return this.socketConnectTimeout;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    @Override
    public boolean sslEnabled() {
        return this.sslEnabled;
    }

    @Override
    public String sslKeystoreFile() {
        return this.sslKeystoreFile;
    }

    @Override
    public String sslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    @Override
    public KeyStore sslKeystore() {
        return this.sslKeystore;
    }

    public Completable shutdown() {
        Observable loopShutdown = Observable.empty();
        if (this.eventLoopGroupIsPrivate) {
            loopShutdown = Completable.create((Completable.OnSubscribe)new Completable.OnSubscribe(){

                public void call(final CompletableSubscriber subscriber) {
                    ClientEnvironment.this.eventLoopGroup.shutdownGracefully(0L, 10L, TimeUnit.MILLISECONDS).addListener(new GenericFutureListener(){

                        public void operationComplete(Future future) throws Exception {
                            if (future.isSuccess()) {
                                subscriber.onCompleted();
                            } else {
                                subscriber.onError(future.cause());
                            }
                        }
                    });
                }
            }).toObservable();
        }
        return Observable.merge(this.schedulerShutdownHook.shutdown(), (Observable)loopShutdown).reduce((Object)true, (previous, current) -> previous != false && current != false).toCompletable();
    }

    public String toString() {
        return "ClientEnvironment{clusterAt=" + this.clusterAt + ", connectionNameGenerator=" + this.connectionNameGenerator + ", bucket='" + this.bucket + '\'' + ", collectionsAware=" + this.collectionsAware + ", collectionIds=" + this.collectionIds + ", collectionNames=" + this.collectionNames + ", scopeId=" + this.scopeId + ", scopeName=" + this.scopeName + ", dcpControl=" + this.dcpControl + ", eventLoopGroup=" + this.eventLoopGroup.getClass().getSimpleName() + ", eventLoopGroupIsPrivate=" + this.eventLoopGroupIsPrivate + ", poolBuffers=" + this.poolBuffers + ", bufferAckWatermark=" + this.bufferAckWatermark + ", connectTimeout=" + this.connectTimeout + ", bootstrapTimeout=" + this.bootstrapTimeout + ", configRefreshInterval=" + this.configRefreshInterval + ", sslEnabled=" + this.sslEnabled + ", sslKeystoreFile='" + this.sslKeystoreFile + '\'' + ", sslKeystorePassword=" + (this.sslKeystorePassword != null && !this.sslKeystorePassword.isEmpty()) + ", sslKeystore=" + this.sslKeystore + '}';
    }

    public Delay dcpChannelsReconnectDelay() {
        return this.dcpChannelsReconnectDelay;
    }

    public int dcpChannelsReconnectMaxAttempts() {
        return this.dcpChannelsReconnectMaxAttempts;
    }

    public static class Builder {
        private List<HostAndPort> clusterAt;
        private NetworkResolution networkResolution = NetworkResolution.AUTO;
        private ConnectionNameGenerator connectionNameGenerator;
        private String bucket;
        private boolean collectionsAware;
        private Set<Long> collectionIds;
        private Set<String> collectionNames;
        private OptionalLong scopeId;
        private Optional<String> scopeName;
        private CredentialsProvider credentialsProvider;
        private Duration configRefreshInterval = DEFAULT_CONFIG_REFRESH_INTERVAL;
        private Duration bootstrapTimeout = DEFAULT_BOOTSTRAP_TIMEOUT;
        private long connectTimeout = DEFAULT_CONNECT_TIMEOUT;
        private DcpControl dcpControl;
        private EventLoopGroup eventLoopGroup;
        private boolean eventLoopGroupIsPrivate;
        private boolean poolBuffers;
        private long socketConnectTimeout = DEFAULT_SOCKET_CONNECT_TIMEOUT;
        private Delay dcpChannelsReconnectDelay = DEFAULT_DCP_CHANNELS_RECONNECT_DELAY;
        private int dcpChannelsReconnectMaxAttempts = Integer.MAX_VALUE;
        private int bufferAckWatermark;
        private EventBus eventBus;
        private boolean sslEnabled = false;
        private String sslKeystoreFile;
        private String sslKeystorePassword;
        private KeyStore sslKeystore;
        private long persistencePollingIntervalMillis;

        public Builder setClusterAt(List<HostAndPort> clusterAt) {
            this.clusterAt = Objects.requireNonNull(clusterAt);
            return this;
        }

        public Builder setNetworkResolution(NetworkResolution nr) {
            this.networkResolution = Objects.requireNonNull(nr);
            return this;
        }

        public Builder setBufferAckWatermark(int watermark) {
            this.bufferAckWatermark = watermark;
            return this;
        }

        public Builder setConnectionNameGenerator(ConnectionNameGenerator connectionNameGenerator) {
            this.connectionNameGenerator = connectionNameGenerator;
            return this;
        }

        public Builder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder setCollectionsAware(boolean collectionsAware) {
            this.collectionsAware = collectionsAware;
            return this;
        }

        public Builder setCollectionIds(Set<Long> collectionIds) {
            this.collectionIds = collectionIds;
            return this;
        }

        public Builder setCollectionNames(Set<String> collectionNames) {
            this.collectionNames = collectionNames;
            return this;
        }

        public Builder setScopeId(OptionalLong scopeId) {
            this.scopeId = scopeId;
            return this;
        }

        public Builder setScopeName(Optional<String> scopeName) {
            this.scopeName = scopeName;
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public Builder setBootstrapTimeout(Duration bootstrapTimeout) {
            this.bootstrapTimeout = bootstrapTimeout;
            return this;
        }

        public Builder setConfigRefreshInterval(Duration configRefreshInterval) {
            this.configRefreshInterval = configRefreshInterval;
            return this;
        }

        public Builder setConnectTimeout(long connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setDcpChannelsReconnectDelay(Delay dcpChannelsReconnectDelay) {
            this.dcpChannelsReconnectDelay = dcpChannelsReconnectDelay;
            return this;
        }

        public Builder setDcpChannelsReconnectMaxAttempts(int dcpChannelsReconnectMaxAttempts) {
            this.dcpChannelsReconnectMaxAttempts = dcpChannelsReconnectMaxAttempts;
            return this;
        }

        public Builder setSocketConnectTimeout(long socketConnectTimeout) {
            this.socketConnectTimeout = socketConnectTimeout;
            return this;
        }

        public Builder setDcpControl(DcpControl dcpControl) {
            this.dcpControl = dcpControl;
            return this;
        }

        public Builder setEventLoopGroup(EventLoopGroup eventLoopGroup, boolean priv) {
            this.eventLoopGroup = eventLoopGroup;
            this.eventLoopGroupIsPrivate = priv;
            return this;
        }

        public Builder setBufferPooling(boolean pool) {
            this.poolBuffers = pool;
            return this;
        }

        public Builder setEventBus(EventBus eventBus) {
            this.eventBus = eventBus;
            return this;
        }

        public Builder setSslEnabled(boolean sslEnabled) {
            this.sslEnabled = sslEnabled;
            return this;
        }

        public Builder setSslKeystoreFile(String sslKeystoreFile) {
            this.sslKeystoreFile = sslKeystoreFile;
            return this;
        }

        public Builder setSslKeystorePassword(String sslKeystorePassword) {
            this.sslKeystorePassword = sslKeystorePassword;
            return this;
        }

        public Builder setSslKeystore(KeyStore sslKeystore) {
            this.sslKeystore = sslKeystore;
            return this;
        }

        public Builder setPersistencePollingIntervalMillis(long persistencePollingIntervalMillis) {
            this.persistencePollingIntervalMillis = persistencePollingIntervalMillis;
            return this;
        }

        public ClientEnvironment build() {
            int defaultKvPort = this.sslEnabled ? 11207 : 11210;
            this.clusterAt = new ArrayList<HostAndPort>(this.clusterAt);
            for (int i = 0; i < this.clusterAt.size(); ++i) {
                HostAndPort node = this.clusterAt.get(i);
                if (node.port() == 8091 || node.port() == 18091) {
                    log.warn("Seed node '{}' uses port '{}' which is likely incorrect. This should be the port of the KV service, not the Manager service. If the connection fails, omit the port so the client can supply the correct default.", (Object)node.host(), (Object)node.port());
                }
                if (node.port() != 0) continue;
                this.clusterAt.set(i, node.withPort(defaultKvPort));
            }
            return new ClientEnvironment(this);
        }
    }
}

