/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.security.sasl;

import com.couchbase.client.dcp.core.security.sasl.ShaSaslClient;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;

public class ShaSaslClientFactory
implements SaslClientFactory {
    private static final String SCRAM_SHA512 = "SCRAM-SHA512";
    private static final String SCRAM_SHA256 = "SCRAM-SHA256";
    private static final String SCRAM_SHA1 = "SCRAM-SHA1";
    private static final String[] SUPPORTED_MECHS = new String[]{"SCRAM-SHA512", "SCRAM-SHA256", "SCRAM-SHA1"};

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        int sha = 0;
        for (String m : mechanisms) {
            if (m.equals(SCRAM_SHA512)) {
                sha = 512;
                break;
            }
            if (m.equals(SCRAM_SHA256)) {
                sha = 256;
                break;
            }
            if (!m.equals(SCRAM_SHA1)) continue;
            sha = 1;
            break;
        }
        if (sha == 0) {
            return null;
        }
        if (authorizationId != null) {
            throw new SaslException("authorizationId is not supported");
        }
        if (cbh == null) {
            throw new SaslException("Callback handler to get username/password required");
        }
        try {
            return new ShaSaslClient(cbh, sha);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return SUPPORTED_MECHS;
    }
}

