/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.highlevel;

import com.couchbase.client.dcp.core.logging.RedactableArgument;
import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.highlevel.StreamOffset;
import com.couchbase.client.dcp.highlevel.internal.CollectionsManifest;
import com.couchbase.client.dcp.highlevel.internal.DatabaseChangeEvent;
import com.couchbase.client.dcp.highlevel.internal.FlowControlReceipt;
import com.couchbase.client.dcp.highlevel.internal.FlowControllable;
import com.couchbase.client.dcp.message.DcpMutationMessage;
import com.couchbase.client.dcp.message.MessageUtil;
import java.util.Objects;

public abstract class DocumentChange
implements DatabaseChangeEvent,
FlowControllable {
    private final int vbucket;
    private final StreamOffset offset;
    private final byte[] content;
    private final boolean mutation;
    private final long revision;
    private final long cas;
    private final CollectionsManifest.CollectionInfo collectionInfo;
    private final String key;
    private final FlowControlReceipt receipt;

    public DocumentChange(ByteBuf byteBuf, CollectionsManifest.CollectionInfo collectionInfo, String key, FlowControlReceipt receipt, StreamOffset offset) {
        this.vbucket = MessageUtil.getVbucket(byteBuf);
        this.mutation = DcpMutationMessage.is(byteBuf);
        this.collectionInfo = Objects.requireNonNull(collectionInfo);
        this.key = Objects.requireNonNull(key);
        this.revision = DcpMutationMessage.revisionSeqno(byteBuf);
        this.offset = Objects.requireNonNull(offset);
        this.receipt = Objects.requireNonNull(receipt);
        this.content = MessageUtil.getContentAsByteArray(byteBuf);
        this.cas = MessageUtil.getCas(byteBuf);
    }

    public byte[] getContent() {
        return this.content;
    }

    @Override
    public int getVbucket() {
        return this.vbucket;
    }

    public StreamOffset getOffset() {
        return this.offset;
    }

    public String getKey() {
        return this.key;
    }

    public String getQualifiedKey() {
        return this.collectionInfo.scope().name() + "." + this.collectionInfo.name() + "." + this.key;
    }

    public CollectionsManifest.CollectionInfo getCollection() {
        return this.collectionInfo;
    }

    public boolean isMutation() {
        return this.mutation;
    }

    public long getRevision() {
        return this.revision;
    }

    public long getCas() {
        return this.cas;
    }

    @Override
    public void flowControlAck() {
        this.receipt.acknowledge();
    }

    public String toString() {
        String type = this.isMutation() ? "MUT" : "DEL";
        return type + ":" + this.getVbucket() + "/" + this.getOffset() + "=" + RedactableArgument.user(this.getQualifiedKey());
    }
}

