/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.highlevel;

import com.couchbase.client.dcp.Client;
import com.couchbase.client.dcp.core.time.Delay;
import com.couchbase.client.dcp.highlevel.DatabaseChangeListener;
import com.couchbase.client.dcp.highlevel.internal.DatabaseChangeEvent;
import com.couchbase.client.dcp.util.retry.RetryBuilder;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Action4;
import rx.functions.Func1;

public class Rollback
implements DatabaseChangeEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(Rollback.class);
    private final Client client;
    private final int vbucket;
    private final long seqno;
    private final Consumer<Throwable> errorHandler;

    public Rollback(Client client, int vbucket, long seqno, Consumer<Throwable> errorHandler) {
        this.client = Objects.requireNonNull(client);
        this.vbucket = vbucket;
        this.seqno = seqno;
        this.errorHandler = Objects.requireNonNull(errorHandler);
    }

    @Override
    public int getVbucket() {
        return this.vbucket;
    }

    public long getSeqno() {
        return this.seqno;
    }

    public void resume() {
        this.client.rollbackAndRestartStream((short)this.vbucket, this.seqno).retryWhen((Func1)RetryBuilder.any().max(Integer.MAX_VALUE).delay(Delay.exponential(TimeUnit.MILLISECONDS, TimeUnit.SECONDS.toMillis(5L))).doOnRetry((Action4<Integer, Throwable, Long, TimeUnit>)((Action4)(retry, cause, delay, delayUnit) -> LOGGER.info("Retrying rollbackAndRestartStream for vbucket {}", (Object)this.vbucket))).build()).subscribe(() -> LOGGER.info("Rollback for partition {} complete!", (Object)this.vbucket), this.errorHandler::accept);
    }

    @Override
    public void dispatch(DatabaseChangeListener listener) {
        listener.onRollback(this);
    }
}

